/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jms.ibmmq;

import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.JMSRuntimeException;
import javax.jms.XAConnectionFactory;
import org.ops4j.pax.jms.ibmmq.ConnectionFactoryAdapter;
import org.ops4j.pax.jms.service.ConnectionFactoryFactory;
import org.ops4j.pax.jms.service.internal.BeanConfig;

public class MQConnectionFactoryFactory
implements ConnectionFactoryFactory {
    private static final String IBM_MQ_CONNECTION_FACTORY_CLASS = "com.ibm.mq.jms.MQConnectionFactory";
    private static final String IBM_MQ_XA_CONNECTION_FACTORY_CLASS = "com.ibm.mq.jms.MQXAConnectionFactory";
    private final Class<?> ibmMqConnectionFactoryClass;
    private final Class<?> ibmMqXaConnectionFactoryClass;

    public MQConnectionFactoryFactory() throws ClassNotFoundException {
        ClassLoader classLoader = MQConnectionFactoryFactory.class.getClassLoader();
        this.ibmMqConnectionFactoryClass = classLoader.loadClass(IBM_MQ_CONNECTION_FACTORY_CLASS);
        this.ibmMqXaConnectionFactoryClass = classLoader.loadClass(IBM_MQ_XA_CONNECTION_FACTORY_CLASS);
    }

    public ConnectionFactory createConnectionFactory(Map<String, Object> props) throws JMSRuntimeException {
        try {
            ConnectionFactory cf = (ConnectionFactory)ConnectionFactory.class.cast(this.ibmMqConnectionFactoryClass.newInstance());
            BeanConfig.configure((Object)cf, props);
            ConnectionFactoryAdapter cfa = new ConnectionFactoryAdapter();
            cfa.setTargetConnectionFactory(cf);
            return cfa;
        }
        catch (Exception ex) {
            throw new JMSRuntimeException(ex.getMessage(), "", (Throwable)ex);
        }
    }

    public XAConnectionFactory createXAConnectionFactory(Map<String, Object> props) throws JMSRuntimeException {
        try {
            XAConnectionFactory cf = (XAConnectionFactory)XAConnectionFactory.class.cast(this.ibmMqXaConnectionFactoryClass.newInstance());
            BeanConfig.configure((Object)cf, props);
            ConnectionFactoryAdapter cfa = new ConnectionFactoryAdapter();
            cfa.setXaTargetConnectionFactory(cf);
            return cfa;
        }
        catch (Exception ex) {
            throw new JMSRuntimeException(ex.getMessage(), "", (Throwable)ex);
        }
    }

    private void setProperties(Object cf, Class<?> clazz, Map<String, Object> props) throws Exception {
        String transportType;
        String hostName = (String)props.remove("hostName");
        clazz.getMethod("setHostName", String.class).invoke(cf, hostName);
        String port = (String)props.remove("port");
        if (port != null) {
            int portNum = Integer.parseInt(port);
            clazz.getMethod("setPort", Integer.TYPE).invoke(cf, portNum);
        }
        String queueManager = (String)props.remove("queueManager");
        clazz.getMethod("setQueueManager", String.class).invoke(cf, queueManager);
        String channel = (String)props.remove("channel");
        if (channel != null) {
            clazz.getMethod("setChannel", String.class).invoke(cf, channel);
        }
        if ((transportType = (String)props.remove("transportType")) != null) {
            int transportTypeNum = Integer.parseInt(transportType);
            clazz.getMethod("setTransportType", Integer.TYPE).invoke(cf, transportTypeNum);
        }
    }
}

