/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jms.ibmmq;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAJMSContext;

public class ConnectionFactoryAdapter
implements ConnectionFactory,
XAConnectionFactory {
    private ConnectionFactory targetConnectionFactory;
    private XAConnectionFactory xaTargetConnectionFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V doCallInTccl(Callable<V> callable) throws JMSException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            V v = callable.call();
            return v;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    private <V> V doCallInTcclRuntimeException(Callable<V> callable) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            V v = callable.call();
            return v;
        }
        catch (JMSException ex) {
            throw new JMSRuntimeException(ex.getMessage(), ex.getErrorCode(), (Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    public ConnectionFactory getTargetConnectionFactory() {
        return this.targetConnectionFactory;
    }

    public void setTargetConnectionFactory(ConnectionFactory targetConnectionFactory) {
        this.targetConnectionFactory = targetConnectionFactory;
    }

    public XAConnectionFactory getXaTargetConnectionFactory() {
        return this.xaTargetConnectionFactory;
    }

    public void setXaTargetConnectionFactory(XAConnectionFactory targetConnectionFactory) {
        this.xaTargetConnectionFactory = targetConnectionFactory;
        if (targetConnectionFactory instanceof ConnectionFactory) {
            this.setTargetConnectionFactory((ConnectionFactory)targetConnectionFactory);
        }
    }

    public Connection createConnection() throws JMSException {
        return this.doCallInTccl(() -> ((ConnectionFactory)this.obtainTargetConnectionFactory()).createConnection());
    }

    public Connection createConnection(String username, String password) throws JMSException {
        return this.doCallInTccl(() -> this.obtainTargetConnectionFactory().createConnection(username, password));
    }

    public JMSContext createContext() {
        return this.doCallInTcclRuntimeException(() -> ((ConnectionFactory)this.obtainTargetConnectionFactory()).createContext());
    }

    public JMSContext createContext(int sessionMode) {
        return this.doCallInTcclRuntimeException(() -> this.obtainTargetConnectionFactory().createContext(sessionMode));
    }

    public JMSContext createContext(String userName, String password) {
        return this.doCallInTcclRuntimeException(() -> this.obtainTargetConnectionFactory().createContext(userName, password));
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        return this.doCallInTcclRuntimeException(() -> this.obtainTargetConnectionFactory().createContext(userName, password, sessionMode));
    }

    public XAConnection createXAConnection() throws JMSException {
        return this.doCallInTccl(() -> ((XAConnectionFactory)this.obtainXaTargetConnectionFactory()).createXAConnection());
    }

    public XAConnection createXAConnection(String username, String password) throws JMSException {
        return this.doCallInTccl(() -> this.obtainXaTargetConnectionFactory().createXAConnection(username, password));
    }

    public XAJMSContext createXAContext() {
        return this.doCallInTcclRuntimeException(() -> ((XAConnectionFactory)this.obtainXaTargetConnectionFactory()).createXAContext());
    }

    public XAJMSContext createXAContext(String username, String password) {
        return this.doCallInTcclRuntimeException(() -> this.obtainXaTargetConnectionFactory().createXAContext(username, password));
    }

    private ConnectionFactory obtainTargetConnectionFactory() {
        return this.targetConnectionFactory;
    }

    private XAConnectionFactory obtainXaTargetConnectionFactory() {
        return this.xaTargetConnectionFactory;
    }

    private static interface Callable<V> {
        public V call() throws JMSException;
    }
}

