/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jms.activemq;

import java.util.HashMap;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAJMSContext;
import org.apache.activemq.ActiveMQSslConnectionFactory;
import org.apache.activemq.ActiveMQXASslConnectionFactory;
import org.ops4j.pax.jms.service.ConnectionFactoryFactory;

public class ActiveMQConnectionFactoryFactory
implements ConnectionFactoryFactory {
    public ConnectionFactory createConnectionFactory(Map<String, Object> props) throws JMSRuntimeException {
        props = new HashMap<String, Object>(props);
        this.rename(props, "user", "userName");
        String url = (String)props.remove("url");
        if (url == null) {
            throw new JMSRuntimeException("The url property must be set");
        }
        final ActiveMQSslConnectionFactory cf = new ActiveMQSslConnectionFactory(url);
        cf.buildFromMap(props);
        return new ConnectionFactory(){

            public Connection createConnection() throws JMSException {
                return cf.createConnection();
            }

            public Connection createConnection(String userName, String password) throws JMSException {
                return cf.createConnection(userName, password);
            }

            public JMSContext createContext() {
                throw new UnsupportedOperationException("JMS 2.0 is not supported by ActiveMQ");
            }

            public JMSContext createContext(int sessionMode) {
                throw new UnsupportedOperationException("JMS 2.0 is not supported by ActiveMQ");
            }

            public JMSContext createContext(String userName, String password) {
                throw new UnsupportedOperationException("JMS 2.0 is not supported by ActiveMQ");
            }

            public JMSContext createContext(String userName, String password, int sessionMode) {
                throw new UnsupportedOperationException("JMS 2.0 is not supported by ActiveMQ");
            }
        };
    }

    public XAConnectionFactory createXAConnectionFactory(Map<String, Object> props) throws JMSRuntimeException {
        props = new HashMap<String, Object>(props);
        this.rename(props, "user", "userName");
        String url = (String)props.remove("url");
        if (url == null) {
            throw new JMSRuntimeException("The url property must be set");
        }
        final ActiveMQXASslConnectionFactory xaCf = new ActiveMQXASslConnectionFactory(url);
        xaCf.buildFromMap(props);
        return new XAConnectionFactory(){

            public XAConnection createXAConnection() throws JMSException {
                return xaCf.createXAConnection();
            }

            public XAConnection createXAConnection(String userName, String password) throws JMSException {
                return xaCf.createXAConnection(userName, password);
            }

            public XAJMSContext createXAContext() {
                throw new UnsupportedOperationException("JMS 2.0 is not supported by ActiveMQ");
            }

            public XAJMSContext createXAContext(String userName, String password) {
                throw new UnsupportedOperationException("JMS 2.0 is not supported by ActiveMQ");
            }
        };
    }

    private void rename(Map<String, Object> props, String oldName, String newName) {
        Object t = props.remove(oldName);
        if (t != null) {
            props.put(newName, t);
        }
    }
}

