/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.teradata.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.ops4j.pax.jdbc.common.BeanConfig;
import org.osgi.service.jdbc.DataSourceFactory;

public class TeradataDataSourceFactory
implements DataSourceFactory {
    private static final String TERA_DATASOURCE_CLASS = "com.teradata.jdbc.TeraDataSource";
    private static final String TERA_CONNECTIONPOOL_DATASOURCE_CLASS = "com.teradata.jdbc.TeraConnectionPoolDataSource";
    private static final String TERA_DRIVER_CLASS = "com.teradata.jdbc.TeraDriver";
    private final Class<?> teraDataSourceClass;
    private final Class<?> teraConnectionPoolDataSourceClass;
    private final Class<?> teraDriverClass;

    public TeradataDataSourceFactory() throws ClassNotFoundException {
        ClassLoader classLoader = TeradataDataSourceFactory.class.getClassLoader();
        this.teraDataSourceClass = classLoader.loadClass(TERA_DATASOURCE_CLASS);
        this.teraConnectionPoolDataSourceClass = classLoader.loadClass(TERA_CONNECTIONPOOL_DATASOURCE_CLASS);
        this.teraDriverClass = classLoader.loadClass(TERA_DRIVER_CLASS);
    }

    public DataSource createDataSource(Properties props) throws SQLException {
        try {
            return (DataSource)this.setProperties(this.teraDataSourceClass.newInstance(), props);
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
    }

    public ConnectionPoolDataSource createConnectionPoolDataSource(Properties props) throws SQLException {
        try {
            return (ConnectionPoolDataSource)this.setProperties(this.teraConnectionPoolDataSourceClass.newInstance(), props);
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
    }

    public XADataSource createXADataSource(Properties props) throws SQLException {
        throw new SQLException("XADataSource not supported");
    }

    public Driver createDriver(Properties props) throws SQLException {
        try {
            return (Driver)Driver.class.cast(this.teraDriverClass.newInstance());
        }
        catch (InstantiationException ex) {
            throw new SQLException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new SQLException(ex);
        }
    }

    private <T> T setProperties(Object dataSourceInstance, Properties properties) throws Exception {
        String password;
        String user;
        String portNumber;
        String serverName;
        String databaseName;
        Properties props = (Properties)properties.clone();
        String url = (String)props.remove("url");
        if (url != null) {
            this.parseUrlAndSetProperty(url.substring(5), dataSourceInstance);
        }
        if ((databaseName = (String)props.remove("databaseName")) == null && url == null) {
            throw new SQLException("missing required property databaseName");
        }
        if (databaseName != null) {
            this.setProperty(databaseName, dataSourceInstance, "setDatabaseName");
        }
        if ((serverName = (String)props.remove("serverName")) != null) {
            this.setProperty(serverName, dataSourceInstance, "setDSName");
        }
        if ((portNumber = (String)props.remove("portNumber")) != null) {
            this.setIntProperty(portNumber, dataSourceInstance, "setDbsPort");
        }
        if ((user = (String)props.remove("user")) != null) {
            this.setProperty(user, dataSourceInstance, "setUser");
        }
        if ((password = (String)props.remove("password")) != null) {
            this.setProperty(password, dataSourceInstance, "setPassword");
        }
        if (!props.isEmpty()) {
            BeanConfig.configure(dataSourceInstance, props);
        }
        return (T)dataSourceInstance;
    }

    private void setProperty(String value, Object instance, String methodName) throws Exception {
        if (value != null) {
            instance.getClass().getMethod(methodName, String.class).invoke(instance, value);
        }
    }

    private void setIntProperty(String value, Object instance, String methodName) throws Exception {
        int iValue = new Integer(value);
        instance.getClass().getMethod(methodName, Integer.TYPE).invoke(instance, iValue);
    }

    private void parseUrlAndSetProperty(String url, Object dataSourceInstance) throws Exception {
        URI uri = URI.create(url);
        Method[] methods = dataSourceInstance.getClass().getMethods();
        if (uri.getHost() != null) {
            this.setProperty(uri.getHost(), dataSourceInstance, "setDSName");
        }
        if (uri.getPort() != -1) {
            this.setIntProperty(uri.getPort() + "", dataSourceInstance, "setDbsPort");
        }
        String path = uri.getPath().substring(1);
        String param = "";
        String value = "";
        StringTokenizer queryParams = new StringTokenizer(path, ",");
        while (queryParams.hasMoreTokens()) {
            StringTokenizer pv = new StringTokenizer(queryParams.nextToken(), "=");
            if (pv.hasMoreTokens()) {
                param = pv.nextToken();
            }
            if (pv.hasMoreTokens()) {
                value = pv.nextToken();
            }
            if (value.length() <= 0 || param.length() <= 0) continue;
            TeradataDataSourceFactory.set(dataSourceInstance, param, value);
        }
    }

    public static boolean set(Object object, String fieldName, Object fieldValue) {
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                field.set(object, fieldValue);
                return true;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return false;
    }
}

