/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.pool.transx.impl;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.resource.spi.TransactionSupport;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import org.ops4j.pax.jdbc.pool.common.PooledDataSourceFactory;
import org.ops4j.pax.transx.jdbc.ManagedDataSourceBuilder;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransxPooledDataSourceFactory
implements PooledDataSourceFactory {
    protected static final String POOL_PREFIX = "pool.";
    private static final Logger LOG = LoggerFactory.getLogger(TransxPooledDataSourceFactory.class);

    public DataSource create(DataSourceFactory dsf, Properties props) throws SQLException {
        try {
            DataSource ds = dsf.createDataSource(this.getNonPoolProps(props));
            DataSource mds = ManagedDataSourceBuilder.builder().dataSource((CommonDataSource)ds).transaction(TransactionSupport.TransactionSupportLevel.NoTransaction).properties(this.getPoolProps(props)).build();
            return mds;
        }
        catch (Throwable e) {
            LOG.error("Error creating pooled datasource" + e.getMessage(), e);
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected Map<String, Object> getPoolProps(Properties props) {
        HashMap<String, Object> poolProps = new HashMap<String, Object>();
        for (Object keyO : props.keySet()) {
            String key = (String)keyO;
            if (!key.startsWith(POOL_PREFIX)) continue;
            String strippedKey = key.substring(POOL_PREFIX.length());
            poolProps.put(strippedKey, props.get(key));
        }
        return poolProps;
    }

    protected Properties getNonPoolProps(Properties props) {
        Properties dsProps = new Properties();
        for (Object keyO : props.keySet()) {
            String key = (String)keyO;
            if (key.startsWith(POOL_PREFIX)) continue;
            dsProps.put(key, props.get(key));
        }
        return dsProps;
    }
}

