/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.pool.hikaricp.impl;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.ops4j.pax.jdbc.pool.common.PooledDataSourceFactory;
import org.osgi.service.jdbc.DataSourceFactory;

public class HikariPooledDataSourceFactory
implements PooledDataSourceFactory {
    protected static final String POOL_PREFIX = "hikari.";
    protected static final String POOL_PREFIX2 = "pool.";

    protected Properties getNonPoolProps(Properties props) {
        Properties dsProps = new Properties();
        for (Object keyO : props.keySet()) {
            String key = (String)keyO;
            if (key.startsWith(POOL_PREFIX) || key.startsWith(POOL_PREFIX2)) continue;
            dsProps.put(key, props.get(key));
        }
        dsProps.remove("dataSourceName");
        return dsProps;
    }

    protected Properties getPoolProps(Properties props) {
        Properties prefixedProps = new Properties();
        for (Object keyO : props.keySet()) {
            String strippedKey;
            String key = (String)keyO;
            if (key.startsWith(POOL_PREFIX)) {
                strippedKey = key.substring(POOL_PREFIX.length());
                prefixedProps.put(strippedKey, props.get(key));
                continue;
            }
            if (!key.startsWith(POOL_PREFIX2)) continue;
            strippedKey = key.substring(POOL_PREFIX2.length());
            prefixedProps.put(strippedKey, props.get(key));
        }
        return prefixedProps;
    }

    public DataSource create(DataSourceFactory dsf, Properties config) throws SQLException {
        try {
            DataSource ds = dsf.createDataSource(this.getNonPoolProps(config));
            Properties poolProps = this.getPoolProps(config);
            HikariConfig hconfig = new HikariConfig(poolProps);
            hconfig.setDataSource(ds);
            return new HikariDataSource(hconfig);
        }
        catch (Throwable e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

