/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.jdbc.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReadWriteLock;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import org.apache.aries.transaction.jdbc.internal.Reflections;
import org.apache.geronimo.connector.outbound.AbstractSinglePoolConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.GenericConnectionManager;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.apache.geronimo.connector.outbound.MultiPoolConnectionInterceptor;
import org.apache.geronimo.connector.outbound.SinglePoolConnectionInterceptor;
import org.apache.geronimo.connector.outbound.SinglePoolMatchAllConnectionInterceptor;
import org.apache.geronimo.connector.outbound.SubjectSource;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionSupport;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTracker;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;

public final class ValidatingGenericConnectionManager
extends GenericConnectionManager {
    private static final Timer TIMER = new Timer("ValidatingGenericConnectionManagerTimer", true);
    private final transient TimerTask validatingTask;
    private final long validatingInterval;
    private final ReadWriteLock lock;
    private final Object pool;

    public ValidatingGenericConnectionManager(TransactionSupport transactionSupport, PoolingSupport pooling, SubjectSource subjectSource, ConnectionTracker connectionTracker, RecoverableTransactionManager transactionManager, ManagedConnectionFactory mcf, String name, ClassLoader classLoader, long interval) {
        super(transactionSupport, pooling, subjectSource, connectionTracker, transactionManager, mcf, name, classLoader);
        this.validatingInterval = interval;
        ConnectionInterceptor stack = this.interceptors.getStack();
        ReadWriteLock foundLock = null;
        ConnectionInterceptor current = stack;
        do {
            if (current instanceof AbstractSinglePoolConnectionInterceptor) {
                try {
                    foundLock = (ReadWriteLock)Reflections.get(current, "resizeLock");
                }
                catch (Exception exception) {}
                break;
            }
            try {
                current = (ConnectionInterceptor)Reflections.get(current, "next");
            }
            catch (Exception e) {
                current = null;
            }
        } while (current != null);
        this.lock = foundLock;
        Object foundPool = null;
        if (current instanceof AbstractSinglePoolConnectionInterceptor) {
            foundPool = Reflections.get(current, "pool");
        } else if (current instanceof MultiPoolConnectionInterceptor) {
            log.warn("validation on stack {} not supported", (Object)stack);
        }
        this.pool = foundPool;
        this.validatingTask = this.pool != null ? new ValidatingTask(current, this.lock, this.pool) : null;
    }

    public void doStart() throws Exception {
        super.doStart();
        if (this.validatingTask != null) {
            TIMER.schedule(this.validatingTask, this.validatingInterval, this.validatingInterval);
        }
    }

    public void doStop() throws Exception {
        if (this.validatingTask != null) {
            this.validatingTask.cancel();
        }
        super.doStop();
    }

    private class ValidatingTask
    extends TimerTask {
        private final ConnectionInterceptor stack;
        private final ReadWriteLock lock;
        private final Object pool;

        public ValidatingTask(ConnectionInterceptor stack, ReadWriteLock lock, Object pool) {
            this.stack = stack;
            this.lock = lock;
            this.pool = pool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.lock != null) {
                this.lock.writeLock().lock();
            }
            try {
                Map<ManagedConnection, ManagedConnectionInfo> connections;
                if (this.stack instanceof SinglePoolConnectionInterceptor) {
                    connections = new HashMap();
                    for (ManagedConnectionInfo info : (List)this.pool) {
                        connections.put(info.getManagedConnection(), info);
                    }
                } else if (this.stack instanceof SinglePoolMatchAllConnectionInterceptor) {
                    connections = (Map)this.pool;
                } else {
                    log.warn("stack {} currently not supported", (Object)this.stack);
                    return;
                }
                try {
                    Set invalids = ((ValidatingManagedConnectionFactory)ValidatingManagedConnectionFactory.class.cast(ValidatingGenericConnectionManager.this.getManagedConnectionFactory())).getInvalidConnections(connections.keySet());
                    if (invalids != null) {
                        for (ManagedConnection invalid : invalids) {
                            this.stack.returnConnection(new ConnectionInfo((ManagedConnectionInfo)connections.get(invalid)), ConnectionReturnAction.DESTROY);
                        }
                    }
                }
                catch (ResourceException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                if (this.lock != null) {
                    this.lock.writeLock().unlock();
                }
            }
        }
    }
}

