/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.jdbc.internal;

import java.sql.Connection;
import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.TransactionSupport;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import org.apache.aries.transaction.jdbc.internal.AbstractMCFFactory;
import org.tranql.connector.CredentialExtractor;
import org.tranql.connector.jdbc.AbstractLocalDataSourceMCF;

public class DataSourceMCFFactory
extends AbstractMCFFactory {
    @Override
    public void init() throws Exception {
        if (this.getDataSource() == null) {
            throw new IllegalArgumentException("dataSource must be set");
        }
        if (this.connectionFactory == null) {
            this.connectionFactory = new DataSourceMCF();
        }
    }

    public class DataSourceMCF
    extends AbstractLocalDataSourceMCF<DataSource>
    implements TransactionSupport {
        public DataSourceMCF() {
            super((DataSource)DataSourceMCFFactory.this.getDataSource(), DataSourceMCFFactory.this.getExceptionSorter(), true);
        }

        @Override
        public String getUserName() {
            return DataSourceMCFFactory.this.getUserName();
        }

        @Override
        public String getPassword() {
            return DataSourceMCFFactory.this.getPassword();
        }

        @Override
        protected Connection getPhysicalConnection(Subject subject, CredentialExtractor credentialExtractor) throws ResourceException {
            try {
                String userName = credentialExtractor.getUserName();
                String password = credentialExtractor.getPassword();
                if (userName != null) {
                    return this.dataSource.getConnection(userName, password);
                }
                return this.dataSource.getConnection();
            }
            catch (SQLException e) {
                throw new ResourceAdapterInternalException("Unable to obtain physical connection to " + this.dataSource, (Throwable)e);
            }
        }

        public TransactionSupport.TransactionSupportLevel getTransactionSupport() {
            return TransactionSupport.TransactionSupportLevel.LocalTransaction;
        }
    }
}

