/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.jdbc.internal;

import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import org.apache.aries.transaction.AriesTransactionManager;
import org.apache.aries.transaction.jdbc.internal.ValidatingDelegatingManagedConnectionFactory;
import org.apache.aries.transaction.jdbc.internal.ValidatingGenericConnectionManager;
import org.apache.geronimo.connector.outbound.GenericConnectionManager;
import org.apache.geronimo.connector.outbound.SubjectSource;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.LocalTransactions;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.NoPool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.NoTransactions;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PartitionedPool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.SinglePool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.XATransactions;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTracker;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTrackingCoordinator;
import org.apache.geronimo.connector.outbound.connectiontracking.GeronimoTransactionListener;
import org.apache.geronimo.connector.outbound.connectiontracking.TrackedConnectionAssociator;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.apache.geronimo.transaction.manager.TransactionManagerMonitor;
import org.tranql.connector.UserPasswordManagedConnectionFactory;

public class ConnectionManagerFactory {
    private AriesTransactionManager transactionManager;
    private ManagedConnectionFactory managedConnectionFactory;
    private String name;
    private TransactionSupport transactionSupport;
    private String transaction;
    private PoolingSupport poolingSupport;
    private boolean pooling = true;
    private String partitionStrategy;
    private int poolMaxSize = 10;
    private int poolMinSize = 0;
    private boolean allConnectionsEqual = true;
    private int connectionMaxWaitMilliseconds = 5000;
    private int connectionMaxIdleMinutes = 15;
    private boolean validateOnMatch = true;
    private boolean backgroundValidation = false;
    private int backgroundValidationMilliseconds = 600000;
    private SubjectSource subjectSource;
    private ConnectionTrackingCoordinator connectionTracker;
    private TransactionManagerMonitor transactionManagerMonitor;
    private GenericConnectionManager connectionManager;

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void init() throws Exception {
        if (this.transactionManager == null && ("xa".equals(this.transaction) || "local".equals(this.transaction))) {
            throw new IllegalArgumentException("transactionManager must be set");
        }
        if (this.managedConnectionFactory == null) {
            throw new IllegalArgumentException("managedConnectionFactory must be set");
        }
        if (this.validateOnMatch || this.backgroundValidation) {
            this.allConnectionsEqual = false;
        }
        if (this.transactionSupport == null) {
            if ("local".equalsIgnoreCase(this.transaction)) {
                this.transactionSupport = LocalTransactions.INSTANCE;
            } else if ("none".equalsIgnoreCase(this.transaction)) {
                this.transactionSupport = NoTransactions.INSTANCE;
            } else if ("xa".equalsIgnoreCase(this.transaction)) {
                this.transactionSupport = new XATransactions(true, false);
            } else {
                throw new IllegalArgumentException("Unknown transaction type " + this.transaction + " (must be local, none or xa)");
            }
        }
        if (this.poolingSupport == null) {
            if (!this.pooling) {
                this.poolingSupport = new NoPool();
            } else if (this.partitionStrategy == null || "none".equalsIgnoreCase(this.partitionStrategy)) {
                this.poolingSupport = new SinglePool(this.poolMaxSize, this.poolMinSize, this.connectionMaxWaitMilliseconds, this.connectionMaxIdleMinutes, this.allConnectionsEqual, !this.allConnectionsEqual, false);
            } else if ("by-connector-properties".equalsIgnoreCase(this.partitionStrategy)) {
                this.poolingSupport = new PartitionedPool(this.poolMaxSize, this.poolMinSize, this.connectionMaxWaitMilliseconds, this.connectionMaxIdleMinutes, this.allConnectionsEqual, !this.allConnectionsEqual, false, true, false);
            } else if ("by-subject".equalsIgnoreCase(this.partitionStrategy)) {
                this.poolingSupport = new PartitionedPool(this.poolMaxSize, this.poolMinSize, this.connectionMaxWaitMilliseconds, this.connectionMaxIdleMinutes, this.allConnectionsEqual, !this.allConnectionsEqual, false, false, true);
            } else {
                throw new IllegalArgumentException("Unknown partition strategy " + this.partitionStrategy + " (must be none, by-connector-properties or by-subject)");
            }
        }
        if (this.connectionTracker == null) {
            this.connectionTracker = new ConnectionTrackingCoordinator();
        }
        if (this.transactionManagerMonitor == null && this.transactionManager != null) {
            this.transactionManagerMonitor = new GeronimoTransactionListener((TrackedConnectionAssociator)this.connectionTracker);
            this.transactionManager.addTransactionAssociationListener(this.transactionManagerMonitor);
        }
        if (this.connectionManager == null) {
            if (this.validateOnMatch || this.backgroundValidation) {
                this.managedConnectionFactory = new ValidatingDelegatingManagedConnectionFactory((UserPasswordManagedConnectionFactory)this.managedConnectionFactory);
            }
            this.connectionManager = this.backgroundValidation ? new ValidatingGenericConnectionManager(this.transactionSupport, this.poolingSupport, this.subjectSource, (ConnectionTracker)this.connectionTracker, (RecoverableTransactionManager)this.transactionManager, this.managedConnectionFactory, this.name != null ? this.name : this.getClass().getName(), this.getClass().getClassLoader(), this.backgroundValidationMilliseconds) : new GenericConnectionManager(this.transactionSupport, this.poolingSupport, this.subjectSource, (ConnectionTracker)this.connectionTracker, (RecoverableTransactionManager)this.transactionManager, this.managedConnectionFactory, this.name != null ? this.name : this.getClass().getName(), this.getClass().getClassLoader());
            this.connectionManager.doStart();
        }
    }

    public void destroy() throws Exception {
        if (this.connectionManager != null) {
            this.connectionManager.doStop();
            this.connectionManager = null;
        }
        if (this.transactionManagerMonitor != null && this.transactionManager != null) {
            this.transactionManager.removeTransactionAssociationListener(this.transactionManagerMonitor);
        }
    }

    public AriesTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(AriesTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.managedConnectionFactory;
    }

    public void setManagedConnectionFactory(ManagedConnectionFactory managedConnectionFactory) {
        this.managedConnectionFactory = managedConnectionFactory;
    }

    public TransactionSupport getTransactionSupport() {
        return this.transactionSupport;
    }

    public void setTransactionSupport(TransactionSupport transactionSupport) {
        this.transactionSupport = transactionSupport;
    }

    public String getTransaction() {
        return this.transaction;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTransaction(String transaction) {
        this.transaction = transaction;
    }

    public PoolingSupport getPoolingSupport() {
        return this.poolingSupport;
    }

    public void setPoolingSupport(PoolingSupport poolingSupport) {
        this.poolingSupport = poolingSupport;
    }

    public boolean isPooling() {
        return this.pooling;
    }

    public void setPooling(boolean pooling) {
        this.pooling = pooling;
    }

    public String getPartitionStrategy() {
        return this.partitionStrategy;
    }

    public void setPartitionStrategy(String partitionStrategy) {
        this.partitionStrategy = partitionStrategy;
    }

    public int getPoolMaxSize() {
        return this.poolMaxSize;
    }

    public void setPoolMaxSize(int poolMaxSize) {
        this.poolMaxSize = poolMaxSize;
    }

    public int getPoolMinSize() {
        return this.poolMinSize;
    }

    public void setPoolMinSize(int poolMinSize) {
        this.poolMinSize = poolMinSize;
    }

    public boolean isAllConnectionsEqual() {
        return this.allConnectionsEqual;
    }

    public void setAllConnectionsEqual(boolean allConnectionsEqual) {
        this.allConnectionsEqual = allConnectionsEqual;
    }

    public int getConnectionMaxWaitMilliseconds() {
        return this.connectionMaxWaitMilliseconds;
    }

    public void setConnectionMaxWaitMilliseconds(int connectionMaxWaitMilliseconds) {
        this.connectionMaxWaitMilliseconds = connectionMaxWaitMilliseconds;
    }

    public int getConnectionMaxIdleMinutes() {
        return this.connectionMaxIdleMinutes;
    }

    public void setConnectionMaxIdleMinutes(int connectionMaxIdleMinutes) {
        this.connectionMaxIdleMinutes = connectionMaxIdleMinutes;
    }

    public boolean isValidateOnMatch() {
        return this.validateOnMatch;
    }

    public void setValidateOnMatch(boolean validateOnMatch) {
        this.validateOnMatch = validateOnMatch;
    }

    public boolean isBackgroundValidation() {
        return this.backgroundValidation;
    }

    public void setBackgroundValidation(boolean backgroundValidation) {
        this.backgroundValidation = backgroundValidation;
    }

    public int getBackgroundValidationMilliseconds() {
        return this.backgroundValidationMilliseconds;
    }

    public void setBackgroundValidationMilliseconds(int backgroundValidationMilliseconds) {
        this.backgroundValidationMilliseconds = backgroundValidationMilliseconds;
    }

    public SubjectSource getSubjectSource() {
        return this.subjectSource;
    }

    public void setSubjectSource(SubjectSource subjectSource) {
        this.subjectSource = subjectSource;
    }
}

