/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.pool.aries.impl;

import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.aries.transaction.AriesTransactionManager;
import org.apache.aries.transaction.jdbc.RecoverableDataSource;
import org.ops4j.pax.jdbc.common.BeanConfig;
import org.ops4j.pax.jdbc.pool.aries.impl.AriesPooledDataSourceFactory;
import org.osgi.service.jdbc.DataSourceFactory;

public class AriesXaPooledDataSourceFactory
extends AriesPooledDataSourceFactory {
    private AriesTransactionManager tm;

    public AriesXaPooledDataSourceFactory(AriesTransactionManager tm) {
        this.tm = tm;
    }

    @Override
    public DataSource create(DataSourceFactory dsf, Properties props) throws SQLException {
        try {
            XADataSource ds = dsf.createXADataSource(this.getNonPoolProps(props));
            RecoverableDataSource mds = new RecoverableDataSource();
            mds.setUsername(props.getProperty("user"));
            mds.setPassword(props.getProperty("password"));
            mds.setDataSource(ds);
            mds.setTransactionManager(this.tm);
            BeanConfig.configure((Object)mds, this.getPoolProps(props));
            mds.start();
            return mds;
        }
        catch (Throwable e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

