/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.jdbc.internal;

import java.util.Hashtable;
import java.util.Map;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.aries.transaction.AriesTransactionManager;
import org.apache.aries.transaction.jdbc.internal.AbstractMCFFactory;
import org.apache.aries.transaction.jdbc.internal.ConnectionManagerFactory;
import org.apache.aries.transaction.jdbc.internal.DataSourceMCFFactory;
import org.apache.aries.transaction.jdbc.internal.Recovery;
import org.apache.aries.transaction.jdbc.internal.XADataSourceMCFFactory;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ManagedDataSourceFactory {
    private final ServiceReference reference;
    private final AriesTransactionManager transactionManager;
    private final CommonDataSource dataSource;
    private final Map<String, Object> properties;
    private ServiceRegistration<DataSource> registration;
    private ConnectionManagerFactory cm;

    public ManagedDataSourceFactory(ServiceReference reference, AriesTransactionManager transactionManager) {
        this.reference = reference;
        this.transactionManager = transactionManager;
        this.properties = new Hashtable<String, Object>();
        for (String key : reference.getPropertyKeys()) {
            this.properties.put(key, reference.getProperty(key));
        }
        this.dataSource = (CommonDataSource)reference.getBundle().getBundleContext().getService(reference);
    }

    public AriesTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public CommonDataSource getDataSource() {
        return this.dataSource;
    }

    public String getResourceName() {
        return this.getString("aries.xa.name", null);
    }

    private String getString(String name, String def) {
        Object v = this.properties.get(name);
        if (v instanceof String) {
            return (String)v;
        }
        return def;
    }

    private int getInt(String name, int def) {
        Object v = this.properties.get(name);
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (v instanceof String) {
            return Integer.parseInt((String)v);
        }
        return def;
    }

    private boolean getBool(String name, boolean def) {
        Object v = this.properties.get(name);
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof String) {
            return Boolean.parseBoolean((String)v);
        }
        return def;
    }

    public void register() throws Exception {
        boolean isXaDataSource = this.dataSource instanceof XADataSource;
        Hashtable<String, Object> props = new Hashtable<String, Object>(this.properties);
        props.put("aries.managed", "true");
        if (isXaDataSource) {
            props.put("aries.xa.aware", "true");
        }
        props.put("service.ranking", this.getInt("service.ranking", 0) + 1000);
        AbstractMCFFactory mcf = isXaDataSource ? new XADataSourceMCFFactory() : new DataSourceMCFFactory();
        mcf.setDataSource(this.dataSource);
        mcf.setExceptionSorterAsString(this.getString("aries.xa.exceptionSorter", "all"));
        mcf.setUserName(this.getString("aries.xa.username", null));
        mcf.setPassword(this.getString("aries.xa.password", null));
        mcf.init();
        this.cm = new ConnectionManagerFactory();
        this.cm.setManagedConnectionFactory(mcf.getConnectionFactory());
        this.cm.setTransactionManager(this.transactionManager);
        this.cm.setAllConnectionsEqual(this.getBool("aries.xa.allConnectionsEquals", true));
        this.cm.setConnectionMaxIdleMinutes(this.getInt("aries.xa.connectionMadIdleMinutes", 15));
        this.cm.setConnectionMaxWaitMilliseconds(this.getInt("aries.xa.connectionMaxWaitMilliseconds", 5000));
        this.cm.setPartitionStrategy(this.getString("aries.xa.partitionStrategy", null));
        this.cm.setPooling(this.getBool("aries.xa.pooling", true));
        this.cm.setPoolMaxSize(this.getInt("aries.xa.poolMaxSize", 10));
        this.cm.setPoolMinSize(this.getInt("aries.xa.poolMinSize", 0));
        this.cm.setValidateOnMatch(this.getBool("aries.xa.validateOnMatch", true));
        this.cm.setBackgroundValidation(this.getBool("aries.xa.backgroundValidation", false));
        this.cm.setBackgroundValidationMilliseconds(this.getInt("aries.xa.backgroundValidationMilliseconds", 600000));
        this.cm.setTransaction(this.getString("aries.xa.transaction", isXaDataSource ? "xa" : "local"));
        this.cm.setName(this.getResourceName());
        this.cm.init();
        BundleContext context = this.reference.getBundle().getBundleContext();
        DataSource ds = (DataSource)this.cm.getManagedConnectionFactory().createConnectionFactory(this.cm.getConnectionManager());
        this.registration = context.registerService(DataSource.class, (Object)ds, props);
        if (isXaDataSource) {
            Recovery.recover(this.getResourceName(), (XADataSource)this.dataSource, (RecoverableTransactionManager)this.transactionManager);
        }
    }

    public void unregister() throws Exception {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        if (this.cm != null) {
            this.cm.destroy();
        }
    }
}

