/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.aries.transaction.AriesTransactionManager;
import org.apache.aries.transaction.jdbc.internal.AbstractMCFFactory;
import org.apache.aries.transaction.jdbc.internal.ConnectionManagerFactory;
import org.apache.aries.transaction.jdbc.internal.DataSourceMCFFactory;
import org.apache.aries.transaction.jdbc.internal.Recovery;
import org.apache.aries.transaction.jdbc.internal.XADataSourceMCFFactory;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

public class RecoverableDataSource
implements DataSource {
    private CommonDataSource dataSource;
    private AriesTransactionManager transactionManager;
    private String name;
    private String exceptionSorter = "all";
    private String username = "";
    private String password = "";
    private boolean allConnectionsEquals = true;
    private int connectionMaxIdleMinutes = 15;
    private int connectionMaxWaitMilliseconds = 5000;
    private String partitionStrategy = "none";
    private boolean pooling = true;
    private int poolMaxSize = 10;
    private int poolMinSize = 0;
    private String transaction;
    private boolean validateOnMatch = true;
    private boolean backgroundValidation = false;
    private int backgroundValidationMilliseconds = 600000;
    private DataSource delegate;

    public void setName(String name) {
        this.name = name;
    }

    public void setDataSource(CommonDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setTransactionManager(AriesTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setExceptionSorter(String exceptionSorter) {
        this.exceptionSorter = exceptionSorter;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAllConnectionsEquals(boolean allConnectionsEquals) {
        this.allConnectionsEquals = allConnectionsEquals;
    }

    public void setConnectionMaxIdleMinutes(int connectionMaxIdleMinutes) {
        this.connectionMaxIdleMinutes = connectionMaxIdleMinutes;
    }

    public void setConnectionMaxWaitMilliseconds(int connectionMaxWaitMilliseconds) {
        this.connectionMaxWaitMilliseconds = connectionMaxWaitMilliseconds;
    }

    public void setPartitionStrategy(String partitionStrategy) {
        this.partitionStrategy = partitionStrategy;
    }

    public void setPooling(boolean pooling) {
        this.pooling = pooling;
    }

    public void setPoolMaxSize(int poolMaxSize) {
        this.poolMaxSize = poolMaxSize;
    }

    public void setPoolMinSize(int poolMinSize) {
        this.poolMinSize = poolMinSize;
    }

    public void setValidateOnMatch(boolean validateOnMatch) {
        this.validateOnMatch = validateOnMatch;
    }

    public void setBackgroundValidation(boolean backgroundValidation) {
        this.backgroundValidation = backgroundValidation;
    }

    public void setBackgroundValidationMilliseconds(int backgroundValidationMilliseconds) {
        this.backgroundValidationMilliseconds = backgroundValidationMilliseconds;
    }

    public void setTransaction(String transaction) {
        this.transaction = transaction;
    }

    public void start() throws Exception {
        AbstractMCFFactory mcf;
        if (("xa".equals(this.transaction) || "local".equals(this.transaction)) && this.transactionManager == null) {
            throw new IllegalArgumentException("xa or local transactions specified, but no TransactionManager set");
        }
        if ("xa".equals(this.transaction) && !(this.dataSource instanceof XADataSource)) {
            throw new IllegalArgumentException("xa transactions specified, but DataSource does not implement javax.sql.XADataSource");
        }
        if ("xa".equals(this.transaction) || this.transactionManager != null && this.dataSource instanceof XADataSource) {
            mcf = new XADataSourceMCFFactory();
            if (this.transaction == null) {
                this.transaction = "xa";
            }
        } else if (this.dataSource instanceof DataSource) {
            mcf = new DataSourceMCFFactory();
            if (this.transaction == null) {
                this.transaction = this.transactionManager != null ? "local" : "none";
            }
        } else {
            throw new IllegalArgumentException("dataSource must be of type javax.sql.DataSource/XADataSource");
        }
        mcf.setDataSource(this.dataSource);
        mcf.setExceptionSorterAsString(this.exceptionSorter);
        mcf.setUserName(this.username);
        mcf.setPassword(this.password);
        mcf.init();
        ConnectionManagerFactory cm = new ConnectionManagerFactory();
        cm.setManagedConnectionFactory(mcf.getConnectionFactory());
        cm.setTransactionManager(this.transactionManager);
        cm.setAllConnectionsEqual(this.allConnectionsEquals);
        cm.setConnectionMaxIdleMinutes(this.connectionMaxIdleMinutes);
        cm.setConnectionMaxWaitMilliseconds(this.connectionMaxWaitMilliseconds);
        cm.setPartitionStrategy(this.partitionStrategy);
        cm.setPooling(this.pooling);
        cm.setPoolMaxSize(this.poolMaxSize);
        cm.setPoolMinSize(this.poolMinSize);
        cm.setValidateOnMatch(this.validateOnMatch);
        cm.setBackgroundValidation(this.backgroundValidation);
        cm.setBackgroundValidationMilliseconds(this.backgroundValidationMilliseconds);
        cm.setTransaction(this.transaction);
        cm.setName(this.name);
        cm.init();
        this.delegate = (DataSource)cm.getManagedConnectionFactory().createConnectionFactory(cm.getConnectionManager());
        if (this.dataSource instanceof XADataSource) {
            Recovery.recover(this.name, (XADataSource)this.dataSource, (RecoverableTransactionManager)this.transactionManager);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.delegate.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.delegate.getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.delegate.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.delegate.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.delegate.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.delegate.getLoginTimeout();
    }

    @Override
    @IgnoreJRERequirement
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

