/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.jtds.impl;

import java.lang.reflect.Method;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.jtds.jdbc.Driver;
import net.sourceforge.jtds.jdbcx.JtdsDataSource;
import org.osgi.service.jdbc.DataSourceFactory;

public class JTDSDataSourceFactory
implements DataSourceFactory {
    private static final List<Method> METHODS = Arrays.asList(JtdsDataSource.class.getMethods());

    public JtdsDataSource createDataSource(Properties props) throws SQLException {
        try {
            return this.setProperties(new JtdsDataSource(), props);
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
    }

    public JtdsDataSource createConnectionPoolDataSource(Properties props) throws SQLException {
        try {
            return this.setProperties(new JtdsDataSource(), props);
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
    }

    public JtdsDataSource createXADataSource(Properties props) throws SQLException {
        try {
            return this.setProperties(new JtdsDataSource(), props);
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
    }

    public Driver createDriver(Properties props) {
        return new Driver();
    }

    private JtdsDataSource setProperties(JtdsDataSource dsi, Properties props) throws Exception {
        Map<String, String> propsFromUrl = this.parseUrl(props.getProperty("url"));
        for (String string : props.stringPropertyNames()) {
            propsFromUrl.put(string.toUpperCase(), props.getProperty(string));
        }
        for (Map.Entry entry : propsFromUrl.entrySet()) {
            this.setProperty(dsi, (String)entry.getKey(), (String)entry.getValue());
        }
        return dsi;
    }

    Map<String, String> parseUrl(String url) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (url == null || url.trim().isEmpty()) {
            return result;
        }
        if (!url.toLowerCase().startsWith("jdbc:jtds:")) {
            return result;
        }
        try {
            DriverPropertyInfo[] propInfo;
            for (DriverPropertyInfo info : propInfo = new Driver().getPropertyInfo(url, null)) {
                result.put(info.name, info.value);
            }
            return result;
        }
        catch (SQLException e) {
            return result;
        }
    }

    private void setProperty(JtdsDataSource dsi, String key, String value) throws Exception {
        if (value == null) {
            return;
        }
        for (Method method : METHODS) {
            if (method.getParameterTypes().length != 1 || !method.getName().equalsIgnoreCase("set" + key)) continue;
            Class<?> type = method.getParameterTypes()[0];
            if (String.class == type) {
                method.invoke((Object)dsi, value);
                continue;
            }
            if (Integer.TYPE == type) {
                method.invoke((Object)dsi, Integer.parseInt(value));
                continue;
            }
            if (Long.TYPE == type) {
                method.invoke((Object)dsi, Long.parseLong(value));
                continue;
            }
            if (Boolean.TYPE != type) continue;
            method.invoke((Object)dsi, Boolean.parseBoolean(value));
        }
    }
}

