/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.config.impl;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import javax.sql.CommonDataSource;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.jasypt.encryption.StringEncryptor;
import org.ops4j.pax.jdbc.config.impl.DataSourceConfigManager;
import org.ops4j.pax.jdbc.config.impl.DataSourceRegistration;
import org.ops4j.pax.jdbc.config.impl.Decryptor;
import org.ops4j.pax.jdbc.config.impl.ExternalConfigLoader;
import org.ops4j.pax.jdbc.config.impl.PoolingWrapper;
import org.ops4j.pax.jdbc.config.impl.ServiceTrackerHelper;
import org.ops4j.pax.jdbc.hook.PreHook;
import org.ops4j.pax.jdbc.pool.common.PooledDataSourceFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.jdbc.DataSourceFactory;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceWrapper {
    public static final Logger LOG = LoggerFactory.getLogger(DataSourceWrapper.class);
    private ServiceTracker<?, ?> tracker;
    private CommonDataSource ds;

    public DataSourceWrapper(BundleContext context, ExternalConfigLoader externalConfigLoader, CommonDataSource ds, ServiceReference<CommonDataSource> reference) {
        LOG.info("Got service reference {}", (Object)ds);
        this.ds = ds;
        boolean xa = false;
        Object objectClass = reference.getProperty("objectClass");
        if (objectClass instanceof String) {
            xa = XADataSource.class.getName().equals(objectClass);
        } else if (objectClass instanceof String[]) {
            xa = Arrays.stream((String[])objectClass).anyMatch(c -> XADataSource.class.getName().equals(c));
        }
        ProvidedDataSourceFactory providedDataSourceFactory = xa ? new ProvidedDataSourceFactory((XADataSource)ds) : new ProvidedDataSourceFactory((DataSource)ds);
        Dictionary<String, Object> config = this.serviceReferenceProperties(reference);
        Dictionary<String, Object> loadedConfig = externalConfigLoader.resolve(config);
        loadedConfig.put("xa", Boolean.toString(xa));
        loadedConfig.put("service.ranking", this.getInt(config, "service.ranking", 0) + 1000);
        loadedConfig.put("pax.jdbc.service.id.ref", config.get("service.id"));
        String seFilter = DataSourceConfigManager.getStringEncryptorFilter(loadedConfig);
        String pdsfFilter = null;
        try {
            pdsfFilter = DataSourceConfigManager.getPooledDSFFilter(loadedConfig);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        String phFilter = DataSourceConfigManager.getPreHookFilter(loadedConfig);
        ServiceTrackerHelper helper = ServiceTrackerHelper.helper(context);
        if (pdsfFilter == null) {
            throw new IllegalArgumentException("No pooling configuration available for service " + ds.toString() + ": " + loadedConfig);
        }
        String finalPdsfFilter = pdsfFilter;
        this.tracker = helper.track(StringEncryptor.class, seFilter, se -> helper.track(PooledDataSourceFactory.class, finalPdsfFilter, pdsf -> helper.track(PreHook.class, phFilter, ph -> new DataSourceRegistration(context, new PoolingWrapper((PooledDataSourceFactory)pdsf, providedDataSourceFactory), loadedConfig, new Decryptor((StringEncryptor)se).decrypt(loadedConfig), (PreHook)ph), DataSourceRegistration::close)));
    }

    private Dictionary<String, Object> serviceReferenceProperties(ServiceReference<CommonDataSource> reference) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        if (reference != null) {
            for (String key : reference.getPropertyKeys()) {
                result.put(key, reference.getProperty(key));
            }
        }
        return result;
    }

    public void close() {
        if (this.tracker != null) {
            if (this.ds != null) {
                LOG.info("Closed service reference: {}", (Object)this.ds);
            }
            this.tracker.close();
        }
    }

    private int getInt(Dictionary<String, Object> properties, String name, int defaultValue) {
        Object v = properties.get(name);
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (v instanceof String) {
            return Integer.parseInt((String)v);
        }
        return defaultValue;
    }

    private static final class ProvidedDataSourceFactory
    implements DataSourceFactory {
        private DataSource providedDataSource;
        private XADataSource providedXADataSource;

        ProvidedDataSourceFactory(DataSource providedDataSource) {
            this.providedDataSource = providedDataSource;
        }

        ProvidedDataSourceFactory(XADataSource providedXADataSource) {
            this.providedXADataSource = providedXADataSource;
        }

        public DataSource createDataSource(Properties props) throws SQLException {
            return this.providedDataSource;
        }

        public ConnectionPoolDataSource createConnectionPoolDataSource(Properties props) throws SQLException {
            throw new UnsupportedOperationException("Only javax.sql.DataSource and javax.sql.XADataSource can be created");
        }

        public XADataSource createXADataSource(Properties props) throws SQLException {
            return this.providedXADataSource;
        }

        public Driver createDriver(Properties props) throws SQLException {
            throw new UnsupportedOperationException("Only javax.sql.DataSource and javax.sql.XADataSource can be created");
        }
    }
}

