/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.config.impl;

import java.io.Closeable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.ops4j.pax.jdbc.hook.PreHook;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceRegistration
implements Closeable {
    static final String DATASOURCE_TYPE = "dataSourceType";
    static final String MANAGED_DATASOURCE = "pax.jdbc.managed";
    static final String JNDI_SERVICE_NAME = "osgi.jndi.service.name";
    private static final Set<String> NOT_FORWARDED_KEYS = new HashSet<String>(Arrays.asList("dataSourceName", "dataSourceType"));
    private static final Set<String> FORWARDED_KEY_PREFIXES = new HashSet<String>(Arrays.asList("pool.", "factory.", "hikari.", "c3p0."));
    private static final String CONFIG_KEY_PREFIX = "jdbc.";
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceRegistration.class);
    private AutoCloseable dataSource;
    private ServiceRegistration serviceReg;

    public DataSourceRegistration(BundleContext context, DataSourceFactory dsf, Dictionary config, Dictionary decryptedConfig, PreHook preHook) {
        String dsName = DataSourceRegistration.getDSName(config);
        if (dsName != null) {
            config.put(JNDI_SERVICE_NAME, dsName);
        }
        try {
            LOG.info("Found DataSourceFactory. Creating DataSource {}", (Object)dsName);
            String typeName = (String)config.get(DATASOURCE_TYPE);
            Class<?> type = this.getType(typeName);
            Object ds = this.createDs(dsf, type, decryptedConfig);
            if (ds instanceof AutoCloseable) {
                this.dataSource = (AutoCloseable)ds;
            }
            if (preHook != null && ds instanceof DataSource) {
                LOG.info("Executing pre hook for DataSource {}", (Object)dsName);
                preHook.prepare((DataSource)ds);
                LOG.info("Pre hook finished. Publishing DataSource {}", (Object)dsName);
            }
            Dictionary serviceProperties = this.filterHidden(config);
            serviceProperties.put(MANAGED_DATASOURCE, "true");
            this.serviceReg = context.registerService(type.getName(), ds, serviceProperties);
        }
        catch (SQLException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }

    static String getDSName(Dictionary config) {
        String jndiName = (String)config.get(JNDI_SERVICE_NAME);
        String dsName = (String)config.get("dataSourceName");
        if (dsName == null && jndiName == null) {
            throw new IllegalStateException("Can not determine DataSource name. Must set osgi.jndi.service.name or dataSourceName");
        }
        return jndiName != null ? jndiName : dsName;
    }

    @Override
    public void close() {
        if (this.serviceReg != null) {
            this.serviceReg.unregister();
        }
        this.safeClose(this.dataSource);
    }

    private Class<?> getType(String typeName) {
        if (typeName == null || DataSource.class.getSimpleName().equals(typeName)) {
            return DataSource.class;
        }
        if (ConnectionPoolDataSource.class.getSimpleName().equals(typeName)) {
            return ConnectionPoolDataSource.class;
        }
        if (XADataSource.class.getSimpleName().equals(typeName)) {
            return XADataSource.class;
        }
        String msg = String.format("Problem in DataSource config : %s must be one of %s , %s, %s", DATASOURCE_TYPE, DataSource.class.getSimpleName(), ConnectionPoolDataSource.class.getSimpleName(), XADataSource.class.getSimpleName());
        throw new IllegalArgumentException(msg);
    }

    private Object createDs(DataSourceFactory dsf, Class<?> type, Dictionary decryptedConfig) throws SQLException {
        Objects.requireNonNull(dsf, "Must provide a DataSourceFactory");
        Properties props = this.toProperties(decryptedConfig);
        if (type == DataSource.class) {
            this.addDataSourceName(dsf, decryptedConfig, props);
            return dsf.createDataSource(props);
        }
        if (type == ConnectionPoolDataSource.class) {
            return dsf.createConnectionPoolDataSource(props);
        }
        return dsf.createXADataSource(props);
    }

    private void addDataSourceName(DataSourceFactory dsf, Dictionary config, Properties props) {
        Class<?> dsfClass = dsf.getClass();
        if (dsfClass != null && dsfClass.getName().startsWith("org.ops4j.pax.jdbc.pool.dbcp2")) {
            props.put("dataSourceName", config.get("dataSourceName"));
        }
    }

    private Properties toProperties(Dictionary dict) {
        Properties props = new Properties();
        Enumeration keys = dict.keys();
        while (keys.hasMoreElements()) {
            String originalKey = (String)keys.nextElement();
            String unhiddenKey = this.unhide(originalKey);
            if (this.shouldForwardToDataSourceFactory(unhiddenKey)) {
                props.put(unhiddenKey, dict.get(originalKey));
                continue;
            }
            if (!unhiddenKey.startsWith(CONFIG_KEY_PREFIX)) continue;
            props.put(unhiddenKey.substring(CONFIG_KEY_PREFIX.length()), dict.get(originalKey));
        }
        return props;
    }

    private boolean shouldForwardToDataSourceFactory(String key) {
        boolean shouldForward = !key.contains(".") && !NOT_FORWARDED_KEYS.contains(key);
        Iterator<String> it = FORWARDED_KEY_PREFIXES.iterator();
        while (!shouldForward && it.hasNext()) {
            shouldForward = key.startsWith(it.next());
        }
        return shouldForward;
    }

    private Dictionary filterHidden(Dictionary dict) {
        Hashtable filtered = new Hashtable(dict.size());
        Enumeration keys = dict.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (this.isHidden(key)) continue;
            ((Dictionary)filtered).put(key, dict.get(key));
        }
        return filtered;
    }

    private String unhide(String key) {
        return this.isHidden(key) ? key.substring(1) : key;
    }

    private boolean isHidden(String key) {
        return key != null && key.startsWith(".");
    }

    private void safeClose(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                LOG.warn("Error closing " + closeable.getClass() + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

