/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.config.impl;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.jasypt.encryption.StringEncryptor;
import org.ops4j.pax.jdbc.config.impl.DataSourceRegistration;
import org.ops4j.pax.jdbc.config.impl.Decryptor;
import org.ops4j.pax.jdbc.config.impl.ExternalConfigLoader;
import org.ops4j.pax.jdbc.config.impl.PoolingWrapper;
import org.ops4j.pax.jdbc.config.impl.ServiceTrackerHelper;
import org.ops4j.pax.jdbc.hook.PreHook;
import org.ops4j.pax.jdbc.pool.common.PooledDataSourceFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.jdbc.DataSourceFactory;
import org.osgi.util.tracker.ServiceTracker;

public class DataSourceConfigManager
implements ManagedServiceFactory {
    private BundleContext context;
    private ExternalConfigLoader externalConfigLoader;
    private Map<String, ServiceTracker<?, ?>> trackers;

    public DataSourceConfigManager(BundleContext context, ExternalConfigLoader externalConfigLoader) {
        this.context = context;
        this.externalConfigLoader = externalConfigLoader;
        this.trackers = new HashMap();
    }

    public String getName() {
        return "datasource";
    }

    public void updated(String pid, Dictionary config) throws ConfigurationException {
        this.deleted(pid);
        if (config == null) {
            return;
        }
        Dictionary<String, Object> loadedConfig = this.externalConfigLoader.resolve(config);
        String seFilter = DataSourceConfigManager.getStringEncryptorFilter(loadedConfig);
        String dsfFilter = this.getDSFFilter(loadedConfig);
        String pdsfFilter = DataSourceConfigManager.getPooledDSFFilter(loadedConfig);
        String phFilter = DataSourceConfigManager.getPreHookFilter(loadedConfig);
        ServiceTrackerHelper helper = ServiceTrackerHelper.helper(this.context);
        ServiceTracker<StringEncryptor, ServiceTracker> tracker = Objects.nonNull(pdsfFilter) ? helper.track(StringEncryptor.class, seFilter, se -> helper.track(PooledDataSourceFactory.class, pdsfFilter, pdsf -> helper.track(PreHook.class, phFilter, ph -> helper.track(DataSourceFactory.class, dsfFilter, dsf -> new DataSourceRegistration(this.context, new PoolingWrapper((PooledDataSourceFactory)pdsf, (DataSourceFactory)dsf), loadedConfig, new Decryptor((StringEncryptor)se).decrypt(loadedConfig), (PreHook)ph), DataSourceRegistration::close)))) : helper.track(StringEncryptor.class, seFilter, se -> helper.track(PreHook.class, phFilter, ph -> helper.track(DataSourceFactory.class, dsfFilter, dsf -> new DataSourceRegistration(this.context, (DataSourceFactory)dsf, loadedConfig, new Decryptor((StringEncryptor)se).decrypt(loadedConfig), (PreHook)ph), DataSourceRegistration::close)));
        this.trackers.put(pid, tracker);
    }

    static String getStringEncryptorFilter(Dictionary<String, Object> config) {
        if (Decryptor.isEncrypted(config)) {
            String alias = Decryptor.getAlias(config);
            return DataSourceConfigManager.andFilter(DataSourceConfigManager.eqFilter("objectClass", StringEncryptor.class.getName()), DataSourceConfigManager.eqFilter("alias", alias));
        }
        return null;
    }

    static String getPreHookFilter(Dictionary<String, Object> config) {
        String preHookName = (String)config.get("ops4j.preHook");
        if (preHookName != null) {
            return DataSourceConfigManager.andFilter(DataSourceConfigManager.eqFilter("objectClass", PreHook.class.getName()), DataSourceConfigManager.eqFilter("name", preHookName));
        }
        return null;
    }

    static String getPooledDSFFilter(Dictionary<String, Object> config) throws ConfigurationException {
        String pool = (String)config.remove("pool");
        boolean isXa = DataSourceConfigManager.isXa(config);
        if (pool == null) {
            if (isXa) {
                throw new ConfigurationException(null, "Can not create XA DataSource without pooling.");
            }
            return null;
        }
        return DataSourceConfigManager.andFilter(DataSourceConfigManager.eqFilter("objectClass", PooledDataSourceFactory.class.getName()), DataSourceConfigManager.eqFilter("pool", pool), DataSourceConfigManager.eqFilter("xa", Boolean.toString(isXa)));
    }

    static boolean isXa(Dictionary<String, Object> config) throws ConfigurationException {
        String xa = (String)config.remove("xa");
        if (xa == null) {
            return false;
        }
        if ("true".equals(xa)) {
            return true;
        }
        if ("false".equals(xa)) {
            return false;
        }
        throw new ConfigurationException(null, "Invalid XA configuration provided, XA can only be set to true or false");
    }

    private String getDSFFilter(Dictionary<String, Object> config) throws ConfigurationException {
        String driverClass = (String)config.get("osgi.jdbc.driver.class");
        String driverName = (String)config.get("osgi.jdbc.driver.name");
        if (driverClass == null && driverName == null) {
            throw new ConfigurationException(null, "Could not determine driver to use. Specify either osgi.jdbc.driver.class or osgi.jdbc.driver.name");
        }
        return DataSourceConfigManager.andFilter(DataSourceConfigManager.eqFilter("objectClass", DataSourceFactory.class.getName()), DataSourceConfigManager.eqFilter("osgi.jdbc.driver.class", driverClass), DataSourceConfigManager.eqFilter("osgi.jdbc.driver.name", driverName));
    }

    static String eqFilter(String key, String value) {
        return value != null ? "(" + key + "=" + value + ")" : null;
    }

    static String andFilter(String ... filterList) {
        String last = null;
        StringBuilder filter = new StringBuilder("(&");
        int count = 0;
        for (String filterPart : filterList) {
            if (filterPart == null) continue;
            last = filterPart;
            filter.append(filterPart);
            ++count;
        }
        filter.append(")");
        return count > 1 ? filter.toString() : last;
    }

    public synchronized void deleted(String pid) {
        ServiceTracker<?, ?> tracker = this.trackers.remove(pid);
        if (tracker != null) {
            tracker.close();
        }
    }

    synchronized void destroy() {
        HashSet<String> pidsToDestroy = new HashSet<String>(this.trackers.keySet());
        for (String pid : pidsToDestroy) {
            this.deleted(pid);
        }
    }
}

