/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.options;

import java.util.ArrayList;
import java.util.List;
import org.ops4j.pax.exam.Option;

public class JarProbeOption
implements Option {
    private List<String> resources;
    private List<Class<?>> classes = new ArrayList();
    private List<String> metaInfResources;
    private String name;

    public JarProbeOption() {
        this.resources = new ArrayList<String>();
        this.metaInfResources = new ArrayList<String>();
    }

    public JarProbeOption name(String _name) {
        this.name = _name;
        return this;
    }

    public JarProbeOption classes(Class<?> ... klass) {
        for (Class<?> c : klass) {
            String resource = c.getName().replaceAll("\\.", "/") + ".class";
            this.resources.add(resource);
        }
        return this;
    }

    public JarProbeOption resources(String ... resourcePath) {
        for (String resource : resourcePath) {
            this.resources.add(resource);
        }
        return this;
    }

    public JarProbeOption metaInfResource(String resourcePath) {
        this.metaInfResources.add(resourcePath);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getMetaInfResources() {
        return this.metaInfResources;
    }

    public List<String> getResources() {
        return this.resources;
    }

    public List<Class<?>> getClasses() {
        return this.classes;
    }
}

