/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi.reactors;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.TestContainer;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.spi.StagedExamReactor;
import org.ops4j.pax.exam.spi.intern.DefaultTestAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonStagedReactor
implements StagedExamReactor {
    private static final Logger LOG = LoggerFactory.getLogger(SingletonStagedReactor.class);
    private static SingletonStagedReactor instance;
    private List<TestContainer> testContainers;
    private List<TestProbeBuilder> probes;
    private Map<TestAddress, TestContainer> testToContainerMap = new LinkedHashMap<TestAddress, TestContainer>();

    private SingletonStagedReactor(List<TestContainer> containers, List<TestProbeBuilder> mProbes) {
        this.testContainers = containers;
        this.probes = mProbes;
    }

    private void buildTestMap(List<TestContainer> containers, List<TestProbeBuilder> mProbes) {
        int index = 0;
        for (TestContainer container : containers) {
            String caption = this.buildCaption(containers, container, index);
            for (TestProbeBuilder builder : mProbes) {
                for (TestAddress a : builder.getTests()) {
                    this.testToContainerMap.put(new DefaultTestAddress(a, caption, new Object[0]), container);
                }
            }
            ++index;
        }
    }

    private String buildCaption(List<TestContainer> containers, TestContainer container, int index) {
        if (containers.size() == 1) {
            return container.toString();
        }
        return String.format("%s[%d]", container.toString(), index);
    }

    public static synchronized StagedExamReactor getInstance(List<TestContainer> containers, List<TestProbeBuilder> mProbes) {
        if (instance == null) {
            instance = new SingletonStagedReactor(containers, mProbes);
        } else if (!SingletonStagedReactor.instance.probes.equals(mProbes)) {
            throw new TestContainerException("using the PerSuite reactor strategy, all test classes must share the same probes");
        }
        return instance;
    }

    @Override
    public void invoke(TestAddress address) throws Exception {
        Objects.requireNonNull(address, "TestAddress must not be null.");
        TestContainer testContainer = this.testToContainerMap.get(address);
        if (testContainer == null) {
            throw new IllegalArgumentException("TestAddress " + address + " not from this reactor? Got it from getTargets() really?");
        }
        testContainer.call(address);
    }

    @Override
    public Set<TestAddress> getTargets() {
        this.buildTestMap(this.testContainers, this.probes);
        return this.testToContainerMap.keySet();
    }

    public void tearDown() {
    }

    @Override
    public void beforeSuite() {
        for (TestContainer container : this.testContainers) {
            container.start();
            for (TestProbeBuilder builder : this.probes) {
                LOG.debug("installing probe " + builder);
                try {
                    container.installProbe(builder.build().getStream());
                }
                catch (IOException e) {
                    throw new TestContainerException("Unable to build the probe.", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void afterSuite() {
        for (TestContainer container : this.testContainers) {
            container.stop();
        }
    }

    @Override
    public void beforeClass() {
    }

    @Override
    public void afterClass() {
    }
}

