/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi.intern;

import java.util.Arrays;
import java.util.UUID;
import org.ops4j.pax.exam.TestAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTestAddress
implements TestAddress {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTestAddress.class);
    private final String sig = this.calculate();
    private final TestAddress root;
    private final String caption;
    private final Object[] args;

    public DefaultTestAddress(String caption, Object ... args) {
        this(null, caption, args);
    }

    public DefaultTestAddress(TestAddress parent, String caption, Object ... args) {
        if (parent != null) {
            this.caption = parent.caption() + ":" + caption;
            this.args = parent.arguments();
        } else {
            this.caption = caption;
            this.args = args;
        }
        this.root = this.calculateRoot(parent);
        LOG.debug("NEW ADDRESS= " + this.sig + " parent=" + parent + " root=" + this.root + " args=" + args.toString());
    }

    private String calculate() {
        return "PaxExam-" + UUID.randomUUID().toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.args);
        result = 31 * result + (this.caption == null ? 0 : this.caption.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultTestAddress other = (DefaultTestAddress)obj;
        if (!Arrays.equals(this.args, other.args)) {
            return false;
        }
        return !(this.caption == null ? other.caption != null : !this.caption.equals(other.caption));
    }

    public String identifier() {
        return this.sig;
    }

    public String caption() {
        return this.caption;
    }

    private TestAddress calculateRoot(TestAddress parent) {
        if (parent != null) {
            return parent.root();
        }
        return this;
    }

    public TestAddress root() {
        return this.root;
    }

    public Object[] arguments() {
        return this.args;
    }

    public String toString() {
        return "[TestAddress:" + this.sig + " root:" + this.root.identifier() + "]";
    }
}

