/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.nat.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.ops4j.pax.exam.ExamSystem;
import org.ops4j.pax.exam.TestContainer;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.TestContainerFactory;
import org.ops4j.pax.exam.nat.internal.NativeTestContainer;
import org.osgi.framework.launch.FrameworkFactory;

public class NativeTestContainerFactory
implements TestContainerFactory {
    public TestContainer[] create(ExamSystem system) throws TestContainerException {
        ArrayList<NativeTestContainer> containers = new ArrayList<NativeTestContainer>();
        Iterator<FrameworkFactory> factories = ServiceLoader.load(FrameworkFactory.class).iterator();
        boolean factoryFound = false;
        while (factories.hasNext()) {
            try {
                containers.add(new NativeTestContainer(system, factories.next()));
                factoryFound = true;
            }
            catch (IOException e) {
                throw new TestContainerException("Problem initializing container.", (Throwable)e);
            }
        }
        if (!factoryFound) {
            throw new TestContainerException("No service org.osgi.framework.launch.FrameworkFactory found in META-INF/services on classpath");
        }
        return containers.toArray(new TestContainer[containers.size()]);
    }
}

