/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.karaf.container.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.UUID;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.FileUtils;
import org.ops4j.pax.exam.ExamSystem;
import org.ops4j.pax.exam.karaf.options.KarafFeaturesOption;
import org.ops4j.pax.exam.options.BootClasspathLibraryOption;
import org.ops4j.pax.exam.options.ProvisionOption;
import org.ops4j.pax.exam.options.UrlReference;

public class DependenciesDeployer {
    private static final String KARAF_FEATURE_NS = "http://karaf.apache.org/xmlns/features/v1.0.0";
    private ExamSystem subsystem;
    private File karafBase;
    private File karafHome;

    public DependenciesDeployer(ExamSystem subsystem, File karafBase, File karafHome) {
        this.subsystem = subsystem;
        this.karafBase = karafBase;
        this.karafHome = karafHome;
    }

    public void copyBootClasspathLibraries() throws IOException {
        BootClasspathLibraryOption[] bootClasspathLibraryOptions;
        for (BootClasspathLibraryOption bootClasspathLibraryOption : bootClasspathLibraryOptions = (BootClasspathLibraryOption[])this.subsystem.getOptions(BootClasspathLibraryOption.class)) {
            UrlReference libraryUrl = bootClasspathLibraryOption.getLibraryUrl();
            FileUtils.copyURLToFile((URL)new URL(libraryUrl.getURL()), (File)this.createUnique(libraryUrl.getURL(), new File(this.karafHome + "/lib/boot"), new String[]{"jar"}));
        }
    }

    public void copyReferencedArtifactsToDeployFolder() {
        ProvisionOption[] options;
        File deploy = new File(this.karafBase, "deploy");
        String[] fileEndings = new String[]{"jar", "war", "zip", "kar", "xml"};
        for (ProvisionOption option : options = (ProvisionOption[])this.subsystem.getOptions(ProvisionOption.class)) {
            try {
                File target = this.createUnique(option.getURL(), deploy, fileEndings);
                FileUtils.copyURLToFile((URL)new URL(option.getURL()), (File)target);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private File createUnique(String url, File deploy, String[] fileEndings) {
        String prefix = UUID.randomUUID().toString();
        String realEnding = this.extractPossibleFileEndingIfMavenArtifact(url, fileEndings);
        String fileName = new File(url).getName();
        return new File(deploy, prefix + "_" + fileName + "." + realEnding);
    }

    private String extractPossibleFileEndingIfMavenArtifact(String url, String[] fileEndings) {
        String realEnding = "jar";
        for (String ending : fileEndings) {
            if (url.indexOf("/" + ending + "/") <= 0) continue;
            realEnding = ending;
            break;
        }
        return realEnding;
    }

    public KarafFeaturesOption getDependenciesFeature() {
        if (this.subsystem == null) {
            return null;
        }
        try {
            File featuresXmlFile = new File(this.karafBase, "test-dependencies.xml");
            OutputStreamWriter wr = new OutputStreamWriter((OutputStream)new FileOutputStream(featuresXmlFile), "UTF-8");
            DependenciesDeployer.writeDependenciesFeature(wr, (ProvisionOption[])this.subsystem.getOptions(ProvisionOption.class));
            ((Writer)wr).close();
            String repoUrl = "file:" + featuresXmlFile.toString().replaceAll("\\\\", "/").replaceAll(" ", "%20");
            return new KarafFeaturesOption(repoUrl, "test-dependencies");
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    static void writeDependenciesFeature(Writer writer, ProvisionOption<?> ... provisionOptions) {
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        xof.setProperty("javax.xml.stream.isRepairingNamespaces", true);
        XMLStreamWriter sw = null;
        try {
            sw = xof.createXMLStreamWriter(writer);
            sw.writeStartDocument("UTF-8", "1.0");
            sw.setDefaultNamespace(KARAF_FEATURE_NS);
            sw.writeCharacters("\n");
            sw.writeStartElement("features");
            sw.writeAttribute("name", "test-dependencies");
            sw.writeCharacters("\n");
            sw.writeStartElement("feature");
            sw.writeAttribute("name", "test-dependencies");
            sw.writeCharacters("\n");
            for (ProvisionOption<?> provisionOption : provisionOptions) {
                if (provisionOption.getURL().startsWith("link") || provisionOption.getURL().startsWith("scan-features")) continue;
                sw.writeStartElement("bundle");
                if (provisionOption.getStartLevel() != null) {
                    sw.writeAttribute("start-level", provisionOption.getStartLevel().toString());
                }
                sw.writeCharacters(provisionOption.getURL());
                DependenciesDeployer.endElement(sw);
            }
            DependenciesDeployer.endElement(sw);
            DependenciesDeployer.endElement(sw);
            sw.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Error writing feature " + e.getMessage(), e);
        }
        finally {
            DependenciesDeployer.close(sw);
        }
    }

    private static void endElement(XMLStreamWriter sw) throws XMLStreamException {
        sw.writeEndElement();
        sw.writeCharacters("\n");
    }

    private static void close(XMLStreamWriter sw) {
        if (sw != null) {
            try {
                sw.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
    }
}

