/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.karaf.container.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveExtractor {
    private static final Logger logger = LoggerFactory.getLogger(ArchiveExtractor.class);

    private ArchiveExtractor() {
    }

    public static void extract(URL sourceURL, File targetFolder) throws IOException {
        logger.debug("extracting {} to {}", (Object)sourceURL, (Object)targetFolder);
        if (sourceURL.getProtocol().equals("file") || sourceURL.getProtocol().equals("http") || sourceURL.getProtocol().equals("https")) {
            if (sourceURL.getFile().endsWith(".zip")) {
                ArchiveExtractor.extractZip(sourceURL, targetFolder);
            } else if (sourceURL.getFile().endsWith(".tar.gz")) {
                ArchiveExtractor.extractTarGz(sourceURL, targetFolder);
            } else {
                throw new IllegalStateException(String.format("Unknown packaging (%s); only zip and tar.gz can be handled.", sourceURL));
            }
            return;
        }
        if (sourceURL.toExternalForm().endsWith("/zip")) {
            ArchiveExtractor.extractZip(sourceURL, targetFolder);
        } else if (sourceURL.toExternalForm().endsWith("/tar.gz")) {
            ArchiveExtractor.extractTarGz(sourceURL, targetFolder);
        } else {
            throw new IllegalStateException(String.format("Unknown packaging (%s); only zip and tar.gz can be handled.", sourceURL));
        }
    }

    private static void extractTarGz(URL sourceURL, File targetFolder) throws IOException {
        try (BufferedInputStream buffer = new BufferedInputStream(sourceURL.openStream());
             GzipCompressorInputStream gzip = new GzipCompressorInputStream((InputStream)buffer);
             TarArchiveInputStream archive = new TarArchiveInputStream((InputStream)gzip);){
            ArchiveExtractor.extract((ArchiveInputStream)archive, targetFolder);
        }
    }

    private static void extractZip(URL sourceURL, File targetFolder) throws IOException {
        try (BufferedInputStream buffer = new BufferedInputStream(sourceURL.openStream());
             ZipArchiveInputStream archive = new ZipArchiveInputStream((InputStream)buffer);){
            ArchiveExtractor.extract((ArchiveInputStream)archive, targetFolder);
        }
    }

    private static void extract(ArchiveInputStream is, File targetDir) throws IOException {
        if (targetDir.exists()) {
            FileUtils.forceDelete((File)targetDir);
        }
        targetDir.mkdirs();
        ArchiveEntry entry = is.getNextEntry();
        while (entry != null) {
            logger.trace("processing archive entry {}", (Object)entry.getName());
            String name = entry.getName();
            name = name.substring(name.indexOf("/") + 1);
            File file = new File(targetDir, name);
            if (entry.isDirectory()) {
                file.mkdirs();
            } else {
                file.getParentFile().mkdirs();
                long number = Files.copy((InputStream)is, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                logger.trace("copied {} bytes", (Object)number);
            }
            entry = is.getNextEntry();
        }
    }
}

