/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.karaf.container.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.URL;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.ExamSystem;
import org.ops4j.pax.exam.Info;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.RelativeTimeout;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.TestContainer;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.container.remote.RBCRemoteTarget;
import org.ops4j.pax.exam.karaf.container.internal.ArchiveExtractor;
import org.ops4j.pax.exam.karaf.container.internal.DependenciesDeployer;
import org.ops4j.pax.exam.karaf.container.internal.InternalKarafDistributionConfigurationOption;
import org.ops4j.pax.exam.karaf.container.internal.JavaVersionUtil;
import org.ops4j.pax.exam.karaf.container.internal.JoinUtil;
import org.ops4j.pax.exam.karaf.container.internal.KarafConfigurationFile;
import org.ops4j.pax.exam.karaf.container.internal.KarafConfigurationFileFactory;
import org.ops4j.pax.exam.karaf.container.internal.LoggingBackend;
import org.ops4j.pax.exam.karaf.container.internal.adaptions.KarafManipulator;
import org.ops4j.pax.exam.karaf.container.internal.adaptions.KarafManipulatorFactory;
import org.ops4j.pax.exam.karaf.container.internal.runner.Runner;
import org.ops4j.pax.exam.karaf.options.DoNotModifyLogOption;
import org.ops4j.pax.exam.karaf.options.KarafDistributionBaseConfigurationOption;
import org.ops4j.pax.exam.karaf.options.KarafDistributionConfigurationConsoleOption;
import org.ops4j.pax.exam.karaf.options.KarafDistributionConfigurationFileExtendOption;
import org.ops4j.pax.exam.karaf.options.KarafDistributionConfigurationFileOption;
import org.ops4j.pax.exam.karaf.options.KarafDistributionConfigurationFilePutOption;
import org.ops4j.pax.exam.karaf.options.KarafDistributionConfigurationFileReplacementOption;
import org.ops4j.pax.exam.karaf.options.KarafDistributionConfigurationSecurityOption;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.KarafExamSystemConfigurationOption;
import org.ops4j.pax.exam.karaf.options.KarafFeaturesOption;
import org.ops4j.pax.exam.karaf.options.KeepRuntimeFolderOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.karaf.options.configs.CustomProperties;
import org.ops4j.pax.exam.karaf.options.configs.FeaturesCfg;
import org.ops4j.pax.exam.karaf.options.libraries.OverrideJUnitBundlesOption;
import org.ops4j.pax.exam.options.BootDelegationOption;
import org.ops4j.pax.exam.options.MavenArtifactUrlReference;
import org.ops4j.pax.exam.options.PropagateSystemPropertyOption;
import org.ops4j.pax.exam.options.ServerModeOption;
import org.ops4j.pax.exam.options.SystemPackageOption;
import org.ops4j.pax.exam.options.SystemPropertyOption;
import org.ops4j.pax.exam.options.UrlReference;
import org.ops4j.pax.exam.options.extra.EnvironmentOption;
import org.ops4j.pax.exam.options.extra.VMOption;
import org.ops4j.pax.exam.rbc.client.RemoteBundleContextClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafTestContainer
implements TestContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(KarafTestContainer.class);
    private static final String KARAF_TEST_CONTAINER = "KarafTestContainer.start";
    private static final String EXAM_INJECT_PROPERTY = "pax.exam.inject";
    private static final MavenArtifactUrlReference EXAM_REPO_URL = CoreOptions.maven().groupId("org.ops4j.pax.exam").artifactId("pax-exam-features").version(Info.getPaxExamVersion()).type("xml");
    private final Runner runner;
    private final ExamSystem system;
    private KarafDistributionBaseConfigurationOption framework;
    private KarafManipulator versionAdaptions;
    private boolean started;
    private RBCRemoteTarget target;
    private File targetFolder;
    private File karafBase;
    private Registry registry;
    private static boolean isJava9Compatible;

    public KarafTestContainer(ExamSystem system, KarafDistributionBaseConfigurationOption framework, Runner runner) {
        this.framework = framework;
        this.system = system;
        this.runner = runner;
    }

    public synchronized TestContainer start() {
        try {
            String name = this.system.createID(KARAF_TEST_CONTAINER);
            Option invokerConfiguration = this.getInvokerConfiguration();
            String host = InetAddress.getLoopbackAddress().getHostAddress();
            System.setProperty("java.rmi.server.hostname", host);
            int port = this.openRegistryOnFreePort(host, 21000, 21099);
            ExamSystem subsystem = this.system.fork(CoreOptions.options((Option[])new Option[]{CoreOptions.systemProperty((String)"java.rmi.server.hostname").value(host), CoreOptions.systemProperty((String)"org.ops4j.pax.exam.rbc.rmi.host").value(host), CoreOptions.systemProperty((String)"org.ops4j.pax.exam.rbc.rmi.port").value(Integer.toString(port)), CoreOptions.systemProperty((String)"org.ops4j.pax.exam.rbc.rmi.name").value(name), invokerConfiguration, CoreOptions.systemProperty((String)EXAM_INJECT_PROPERTY).value("true"), KarafDistributionOption.editConfigurationFileExtend("etc/system.properties", "jline.shutdownhook", (Object)"true")}));
            this.target = new RBCRemoteTarget(name, Integer.valueOf(port), subsystem.getTimeout());
            System.setProperty("java.protocol.handler.pkgs", "org.ops4j.pax.url");
            if (this.framework.getExisting() != null) {
                this.targetFolder = this.framework.getExisting();
            } else {
                URL sourceDistribution = new URL(this.framework.getFrameworkURL());
                this.targetFolder = this.retrieveFinalTargetFolder(subsystem);
                ArchiveExtractor.extract(sourceDistribution, this.targetFolder);
            }
            File karafHome = this.karafBase = this.searchKarafBase(this.targetFolder);
            this.versionAdaptions = this.createVersionAdapter(this.karafBase);
            DependenciesDeployer deployer = new DependenciesDeployer(subsystem, this.karafBase, karafHome);
            deployer.copyBootClasspathLibraries();
            if (this.framework.getExisting() != null) {
                this.backupConfigFiles();
            }
            this.setupSystemProperties(karafHome, subsystem);
            this.updateLogProperties(karafHome, subsystem);
            ArrayList<Option> options = new ArrayList<Option>(Arrays.asList(subsystem.getOptions(KarafDistributionConfigurationFileOption.class)));
            options.addAll(this.fromFeatureOptions((KarafFeaturesOption[])subsystem.getOptions(KarafFeaturesOption.class)));
            String usedExamFeature = this.shouldInjectJUnitBundles(this.system) ? "exam" : "exam-no-junit";
            options.addAll(this.fromFeatureOptions(KarafDistributionOption.features((UrlReference)EXAM_REPO_URL, usedExamFeature)));
            if (this.framework.isUseDeployFolder()) {
                deployer.copyReferencedArtifactsToDeployFolder();
            } else {
                options.addAll(this.fromFeatureOptions(deployer.getDependenciesFeature()));
            }
            options.addAll(this.configureBootDelegation(subsystem));
            options.addAll(this.configureSystemPackages(subsystem));
            this.updateUserSetProperties(karafHome, options);
            this.startKaraf(subsystem, this.karafBase, karafHome);
            this.started = true;
        }
        catch (IOException e) {
            throw new RuntimeException("Problem starting container", e);
        }
        return this;
    }

    private void backupConfigFiles() {
        try {
            File karafEtc = new File(this.karafBase, this.framework.getKarafEtc());
            FileUtils.copyFile((File)new File(karafEtc, "config.properties"), (File)new File(karafEtc, "config.properties.paxexam"));
            FileUtils.copyFile((File)new File(karafEtc, "system.properties"), (File)new File(karafEtc, "system.properties.paxexam"));
            FileUtils.copyFile((File)new File(karafEtc, "org.apache.karaf.features.cfg"), (File)new File(karafEtc, "org.apache.karaf.features.cfg.paxexam"));
            FileUtils.copyFile((File)new File(karafEtc, "org.ops4j.pax.logging.cfg"), (File)new File(karafEtc, "org.ops4j.pax.logging.cfg.paxexam"));
        }
        catch (Exception e) {
            LOGGER.warn("Can't backup config files", (Throwable)e);
        }
    }

    private void restoreConfigFiles() {
        try {
            File karafEtc = new File(this.karafBase, this.framework.getKarafEtc());
            FileUtils.copyFile((File)new File(karafEtc, "config.properties.paxexam"), (File)new File(karafEtc, "config.properties"));
            FileUtils.copyFile((File)new File(karafEtc, "system.properties.paxexam"), (File)new File(karafEtc, "system.properties"));
            FileUtils.copyFile((File)new File(karafEtc, "org.apache.karaf.features.cfg.paxexam"), (File)new File(karafEtc, "org.apache.karaf.features.cfg"));
            FileUtils.copyFile((File)new File(karafEtc, "org.ops4j.pax.logging.cfg.paxexam"), (File)new File(karafEtc, "org.ops4j.pax.logging.cfg"));
        }
        catch (Exception e) {
            LOGGER.warn("Can't restore config files", (Throwable)e);
        }
    }

    private int openRegistryOnFreePort(String host, int minPort, int maxPort) throws RemoteException {
        for (int port = minPort; port <= maxPort; ++port) {
            try {
                LOGGER.trace("Creating RMI registry server on {}:{}", (Object)host, (Object)port);
                this.registry = LocateRegistry.createRegistry(port);
                LOGGER.info("Created RMI registry server on {}:{}", (Object)host, (Object)port);
                return port;
            }
            catch (RemoteException ex) {
                if (ex.detail instanceof BindException) {
                    LOGGER.trace("Tried to open RMI registry on {}: {} but failed.", new Object[]{host, port, ex});
                    if (port < maxPort) continue;
                    throw ex;
                }
                throw ex;
            }
        }
        throw new IllegalStateException("Could not open RMI registry");
    }

    private boolean shouldInjectJUnitBundles(ExamSystem _system) {
        Option[] options = _system.getOptions(OverrideJUnitBundlesOption.class);
        LOGGER.info("Found {} options when requesting OverrideJUnitBundlesOption.class", (Object)options.length);
        return options.length == 0;
    }

    private KarafManipulator createVersionAdapter(File karafBase) {
        File karafEtc = new File(karafBase, this.framework.getKarafEtc());
        File distributionInfo = new File(karafEtc, "distribution.info");
        this.framework = new InternalKarafDistributionConfigurationOption(this.framework, distributionInfo);
        return KarafManipulatorFactory.createManipulator(this.framework.getKarafVersion());
    }

    private void startKaraf(ExamSystem subsystem, File karafBase, File karafHome) {
        EnvironmentOption[] environmentOptions;
        long startedAt = System.currentTimeMillis();
        File karafBin = new File(karafBase, "bin");
        File karafEtc = new File(karafBase, this.framework.getKarafEtc());
        File karafData = new File(karafBase, this.framework.getKarafData());
        File karafLog = new File(karafData, this.framework.getKarafLog());
        String[] classPath = this.buildKarafClasspath(karafHome);
        this.makeScriptsInBinExec(karafBin);
        File javaHome = new File(System.getProperty("java.home"));
        String main = this.framework.getKarafMain();
        String options = "";
        ArrayList<String> environment = new ArrayList<String>();
        for (EnvironmentOption environmentOption : environmentOptions = (EnvironmentOption[])subsystem.getOptions(EnvironmentOption.class)) {
            environment.add(environmentOption.getEnvironment());
        }
        ArrayList<String> javaOpts = new ArrayList<String>();
        this.appendVmSettingsFromSystem(javaOpts, subsystem);
        String[] javaEndorsedDirs = null;
        javaEndorsedDirs = KarafTestContainer.isJava9Compatible() ? new String[]{} : new String[]{javaHome + "/jre/lib/endorsed", javaHome + "/lib/endorsed", karafHome + "/lib/endorsed"};
        String[] javaExtDirs = new String[]{javaHome + "/jre/lib/ext", javaHome + "/lib/ext", javaHome + "/lib/ext"};
        List<String> opts = Arrays.asList("-Dkaraf.startLocalConsole=" + this.shouldLocalConsoleBeStarted(subsystem), "-Dkaraf.startRemoteShell=" + this.shouldRemoteShellBeStarted(subsystem));
        boolean enableMBeanServerBuilder = this.shouldMBeanServerBuilderBeEnabled(subsystem);
        String[] karafOpts = new String[]{};
        String[] env = environment.toArray(new String[environment.size()]);
        this.runner.exec(env, karafBase, javaHome.toString(), javaOpts.toArray(new String[0]), javaEndorsedDirs, javaExtDirs, karafHome.toString(), karafData.toString(), karafEtc.toString(), karafLog.toString(), karafOpts, opts.toArray(new String[0]), classPath, main, options, enableMBeanServerBuilder);
        LOGGER.debug("Test Container started in " + (System.currentTimeMillis() - startedAt) + " millis");
        LOGGER.info("Wait for test container to finish its initialization " + subsystem.getTimeout());
        if (((ServerModeOption[])subsystem.getOptions(ServerModeOption.class)).length == 0) {
            this.waitForState(0L, 32, subsystem.getTimeout());
        } else {
            LOGGER.info("System runs in Server Mode. Which means, no Test facility bundles available on target system.");
        }
    }

    private boolean shouldDeleteRuntime() {
        boolean deleteRuntime = true;
        if (this.framework.getExisting() != null) {
            return false;
        }
        KeepRuntimeFolderOption[] keepRuntimeFolder = (KeepRuntimeFolderOption[])this.system.getOptions(KeepRuntimeFolderOption.class);
        if (keepRuntimeFolder != null && keepRuntimeFolder.length != 0) {
            deleteRuntime = false;
        }
        return deleteRuntime;
    }

    private Option getInvokerConfiguration() {
        KarafExamSystemConfigurationOption[] internalConfigurationOptions = (KarafExamSystemConfigurationOption[])this.system.getOptions(KarafExamSystemConfigurationOption.class);
        SystemPropertyOption invokerConfiguration = CoreOptions.systemProperty((String)"pax.exam.invoker").value("junit");
        if (internalConfigurationOptions != null && internalConfigurationOptions.length != 0) {
            invokerConfiguration = CoreOptions.systemProperty((String)"pax.exam.invoker").value(internalConfigurationOptions[0].getInvoker());
        }
        return invokerConfiguration;
    }

    private String shouldRemoteShellBeStarted(ExamSystem subsystem) {
        KarafDistributionConfigurationConsoleOption[] consoleOptions = (KarafDistributionConfigurationConsoleOption[])subsystem.getOptions(KarafDistributionConfigurationConsoleOption.class);
        if (consoleOptions == null) {
            return "true";
        }
        for (KarafDistributionConfigurationConsoleOption consoleOption : consoleOptions) {
            if (consoleOption.getStartRemoteShell() == null) continue;
            return consoleOption.getStartRemoteShell() != false ? "true" : "false";
        }
        return "true";
    }

    private String shouldLocalConsoleBeStarted(ExamSystem subsystem) {
        KarafDistributionConfigurationConsoleOption[] consoleOptions = (KarafDistributionConfigurationConsoleOption[])subsystem.getOptions(KarafDistributionConfigurationConsoleOption.class);
        if (consoleOptions == null) {
            return "true";
        }
        for (KarafDistributionConfigurationConsoleOption consoleOption : consoleOptions) {
            if (consoleOption.getStartLocalConsole() == null) continue;
            return consoleOption.getStartLocalConsole() != false ? "true" : "false";
        }
        return "true";
    }

    private boolean shouldMBeanServerBuilderBeEnabled(ExamSystem subsystem) {
        KarafDistributionConfigurationSecurityOption[] securityOptions = (KarafDistributionConfigurationSecurityOption[])subsystem.getOptions(KarafDistributionConfigurationSecurityOption.class);
        if (securityOptions == null) {
            return false;
        }
        for (KarafDistributionConfigurationSecurityOption securityOption : securityOptions) {
            if (securityOption.getEnableKarafMBeanServerBuilder() == null) continue;
            return securityOption.getEnableKarafMBeanServerBuilder();
        }
        return false;
    }

    private void makeScriptsInBinExec(File karafBin) {
        File[] files;
        if (!karafBin.exists()) {
            return;
        }
        for (File file : files = karafBin.listFiles()) {
            file.setExecutable(true);
        }
    }

    private File retrieveFinalTargetFolder(ExamSystem subsystem) {
        File targetDir;
        if (this.framework.getUnpackDirectory() == null) {
            return subsystem.getConfigFolder();
        }
        if (this.framework.getDirectoryNameFormat() != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.framework.getDirectoryNameFormat());
            targetDir = new File(this.framework.getUnpackDirectory(), simpleDateFormat.format(new Date()));
        } else {
            targetDir = new File(this.framework.getUnpackDirectory(), UUID.randomUUID().toString());
        }
        targetDir = this.transformToAbsolutePath(targetDir);
        targetDir.mkdirs();
        return targetDir;
    }

    private File transformToAbsolutePath(File file) {
        return new File(file.getAbsolutePath());
    }

    private void appendVmSettingsFromSystem(ArrayList<String> opts, ExamSystem subsystem) {
        VMOption[] options;
        for (VMOption option : options = (VMOption[])subsystem.getOptions(VMOption.class)) {
            opts.add(option.getOption());
        }
    }

    private void updateUserSetProperties(File karafHome, List<KarafDistributionConfigurationFileOption> options) throws IOException {
        HashMap optionMap = new HashMap();
        for (KarafDistributionConfigurationFileOption option : options) {
            HashMap optionEntries;
            if (!optionMap.containsKey(option.getConfigurationFilePath())) {
                optionMap.put(option.getConfigurationFilePath(), new HashMap());
            }
            if (!(optionEntries = (HashMap)optionMap.get(option.getConfigurationFilePath())).containsKey(option.getKey())) {
                optionEntries.put(option.getKey(), new ArrayList());
            } else if (!option.getConfigurationFilePath().equals("etc/org.apache.karaf.features.cfg")) {
                LOGGER.warn("you're trying to add an additional value to a config file; you're current value will be replaced.");
                optionEntries.put(option.getKey(), new ArrayList());
            }
            ((List)optionEntries.get(option.getKey())).add(option);
        }
        String karafData = this.framework.getKarafData();
        String karafEtc = this.framework.getKarafEtc();
        Set configFiles = optionMap.keySet();
        for (String configFile : configFiles) {
            KarafConfigurationFile karafConfigurationFile = KarafConfigurationFileFactory.create(karafHome, configFile);
            if (!karafConfigurationFile.exists()) {
                KarafConfigurationFile customConfigurationFile = null;
                if (configFile.startsWith("data/") && !configFile.startsWith(karafData)) {
                    customConfigurationFile = KarafConfigurationFileFactory.create(karafHome, karafData + configFile.substring(4));
                }
                if (configFile.startsWith("etc/") && !configFile.startsWith(karafEtc)) {
                    customConfigurationFile = KarafConfigurationFileFactory.create(karafHome, karafEtc + configFile.substring(3));
                }
                if (customConfigurationFile != null && customConfigurationFile.exists()) {
                    karafConfigurationFile = customConfigurationFile;
                }
            }
            karafConfigurationFile.load();
            Collection optionsToApply = ((HashMap)optionMap.get(configFile)).values();
            boolean store = true;
            for (List optionListToApply : optionsToApply) {
                for (KarafDistributionConfigurationFileOption optionToApply : optionListToApply) {
                    if (optionToApply instanceof KarafDistributionConfigurationFilePutOption) {
                        karafConfigurationFile.put(optionToApply.getKey(), optionToApply.getValue());
                        continue;
                    }
                    if (optionToApply instanceof KarafDistributionConfigurationFileReplacementOption) {
                        karafConfigurationFile.replace(((KarafDistributionConfigurationFileReplacementOption)optionToApply).getSource());
                        store = false;
                        break;
                    }
                    karafConfigurationFile.extend(optionToApply.getKey(), optionToApply.getValue());
                }
                if (store) continue;
                break;
            }
            if (!store) continue;
            karafConfigurationFile.store();
        }
    }

    private Collection<? extends KarafDistributionConfigurationFileOption> configureSystemPackages(ExamSystem subsystem) {
        String systemPackages = JoinUtil.join(subsystem.getOptions(SystemPackageOption.class));
        if (systemPackages.length() == 0) {
            return Arrays.asList(new KarafDistributionConfigurationFileOption[0]);
        }
        return Arrays.asList(new KarafDistributionConfigurationFileExtendOption(CustomProperties.SYSTEM_PACKAGES_EXTRA, systemPackages));
    }

    private Collection<? extends KarafDistributionConfigurationFileOption> configureBootDelegation(ExamSystem subsystem) {
        Object[] bootDelegationOptions = (BootDelegationOption[])subsystem.getOptions(BootDelegationOption.class);
        return Arrays.asList(new KarafDistributionConfigurationFileExtendOption(CustomProperties.BOOTDELEGATION, JoinUtil.join(bootDelegationOptions)));
    }

    private Collection<? extends KarafDistributionConfigurationFileOption> fromFeatureOptions(KarafFeaturesOption ... featuresOptions) {
        ArrayList<KarafDistributionConfigurationFileExtendOption> retVal = new ArrayList<KarafDistributionConfigurationFileExtendOption>();
        for (KarafFeaturesOption featuresOption : featuresOptions) {
            retVal.add(new KarafDistributionConfigurationFileExtendOption(FeaturesCfg.REPOSITORIES, featuresOption.getURL()));
            retVal.add(new KarafDistributionConfigurationFileExtendOption(FeaturesCfg.BOOT, JoinUtil.join(featuresOption.getFeatures())));
        }
        return retVal;
    }

    private void setupSystemProperties(File karafHome, ExamSystem _system) throws IOException {
        File customPropertiesFile = new File(karafHome, this.framework.getKarafEtc() + "/system.properties");
        SystemPropertyOption[] customProps = (SystemPropertyOption[])_system.getOptions(SystemPropertyOption.class);
        Properties karafPropertyFile = new Properties();
        karafPropertyFile.load(new FileInputStream(customPropertiesFile));
        for (SystemPropertyOption systemPropertyOption : customProps) {
            karafPropertyFile.put(systemPropertyOption.getKey(), systemPropertyOption.getValue());
        }
        for (SystemPropertyOption systemPropertyOption : (PropagateSystemPropertyOption[])this.system.getOptions(PropagateSystemPropertyOption.class)) {
            String key = systemPropertyOption.getKey();
            String value = System.getProperty(key);
            if (value == null) continue;
            karafPropertyFile.put(key, value);
        }
        karafPropertyFile.store(new FileOutputStream(customPropertiesFile), "updated by pax-exam");
    }

    private void updateLogProperties(File karafHome, ExamSystem _system) throws IOException {
        DoNotModifyLogOption[] modifyLog = (DoNotModifyLogOption[])_system.getOptions(DoNotModifyLogOption.class);
        if (modifyLog != null && modifyLog.length != 0) {
            LOGGER.info("Log file should not be modified by the test framework");
            return;
        }
        LoggingBackend loggingBackend = this.getLoggingBackend(karafHome);
        String realLogLevel = this.retrieveRealLogLevel(_system);
        File customPropertiesFile = new File(karafHome, this.framework.getKarafEtc() + "/org.ops4j.pax.logging.cfg");
        Properties karafPropertyFile = new Properties();
        karafPropertyFile.load(new FileInputStream(customPropertiesFile));
        loggingBackend.updatePaxLoggingConfiguration(karafPropertyFile, realLogLevel);
        karafPropertyFile.store(new FileOutputStream(customPropertiesFile), "updated by pax-exam");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoggingBackend getLoggingBackend(File karafHome) throws IOException, FileNotFoundException {
        File customisedSystemPropertiesFile = new File(karafHome, this.framework.getKarafEtc() + "/startup.properties");
        try (FileInputStream customisedSystemPropertiesInputStream = null;){
            customisedSystemPropertiesInputStream = new FileInputStream(customisedSystemPropertiesFile);
            Properties customisedSystemProperties = new Properties();
            customisedSystemProperties.load(customisedSystemPropertiesInputStream);
            Set<Object> systemPropertyNames = customisedSystemProperties.keySet();
            for (Object systemPropertyName : systemPropertyNames) {
                if (!systemPropertyName.toString().contains("pax-logging-log4j2")) continue;
                LoggingBackend loggingBackend = LoggingBackend.LOG4J2;
                return loggingBackend;
            }
            Object object = LoggingBackend.LOG4J;
            return object;
        }
    }

    private String retrieveRealLogLevel(ExamSystem _system) {
        LogLevelOption[] logLevelOptions = (LogLevelOption[])_system.getOptions(LogLevelOption.class);
        return logLevelOptions != null && logLevelOptions.length != 0 ? logLevelOptions[0].getLogLevel().toString() : "WARN";
    }

    private String[] buildKarafClasspath(File karafHome) {
        File[] jdk9Plus;
        File[] extJars;
        File[] jars;
        ArrayList<String> cp = new ArrayList<String>();
        for (File jar : jars = new File(karafHome + "/lib").listFiles((FileFilter)new WildcardFileFilter("*.jar"))) {
            cp.add(jar.toString());
        }
        File[] bootJars = new File(karafHome + "/lib/boot").listFiles((FileFilter)new WildcardFileFilter("*.jar"));
        if (bootJars != null) {
            for (File jar : bootJars) {
                cp.add(jar.toString());
            }
        }
        if ((extJars = new File(karafHome + "/lib/ext").listFiles((FileFilter)new WildcardFileFilter("*.jar"))) != null) {
            for (File jar : extJars) {
                cp.add(jar.toString());
            }
        }
        if ((jdk9Plus = new File(karafHome + "/lib/jdk9plus").listFiles((FileFilter)new WildcardFileFilter("*.jar"))) != null) {
            for (File jar : jdk9Plus) {
                cp.add(jar.toString());
            }
        }
        return cp.toArray(new String[0]);
    }

    private File searchKarafBase(File _targetFolder) {
        LinkedList<File> searchNext = new LinkedList<File>();
        searchNext.add(_targetFolder);
        while (!searchNext.isEmpty()) {
            File head = (File)searchNext.poll();
            if (!head.isDirectory()) continue;
            boolean isSystem = false;
            boolean etc = false;
            for (File file : head.listFiles()) {
                if (file.isDirectory() && file.getName().equals("system")) {
                    isSystem = true;
                }
                if (!file.isDirectory() || !file.getName().equals("etc")) continue;
                etc = true;
            }
            if (isSystem && etc) {
                return head;
            }
            searchNext.addAll(Arrays.asList(head.listFiles()));
        }
        throw new IllegalStateException("No karaf base dir found in extracted distribution.");
    }

    public synchronized TestContainer stop() {
        block14: {
            LOGGER.debug("Shutting down the test container (Pax Runner)");
            try {
                if (this.started) {
                    this.target.stop();
                    RemoteBundleContextClient remoteBundleContextClient = this.target.getClientRBC();
                    if (remoteBundleContextClient != null) {
                        remoteBundleContextClient.stop();
                    }
                    if (this.runner != null) {
                        this.runner.shutdown();
                    }
                    try {
                        UnicastRemoteObject.unexportObject(this.registry, true);
                        break block14;
                    }
                    catch (NoSuchObjectException exc) {
                        throw new TestContainerException((Throwable)exc);
                    }
                }
                throw new RuntimeException("Container never came up");
            }
            finally {
                this.started = false;
                this.target = null;
                if (this.framework.getExisting() != null) {
                    this.restoreConfigFiles();
                }
                if (this.shouldDeleteRuntime()) {
                    this.system.clear();
                    try {
                        FileUtils.forceDelete((File)this.targetFolder);
                    }
                    catch (IOException e) {
                        this.forceCleanup();
                    }
                }
            }
        }
        return this;
    }

    private void forceCleanup() {
        LOGGER.info("Can't remove runtime system; schedule it for exit of the jvm.");
        try {
            FileUtils.forceDeleteOnExit((File)this.targetFolder);
        }
        catch (IOException e1) {
            LOGGER.error("Well, this should simply not happen...");
        }
    }

    private void waitForState(long bundleId, int state, RelativeTimeout timeout) {
        this.target.getClientRBC().waitForState(bundleId, state, timeout);
    }

    public synchronized void call(TestAddress address) {
        this.target.call(address);
    }

    public synchronized long install(InputStream stream) {
        return this.install("local", stream);
    }

    public synchronized long install(String location, InputStream stream) {
        return this.target.install(location, stream);
    }

    public String toString() {
        if (this.framework.getExisting() != null) {
            return "KarafTestContainer{" + this.framework.getExisting().getAbsolutePath() + "}";
        }
        return "KarafTestContainer{" + this.framework.getFrameworkURL() + "}";
    }

    public long installProbe(InputStream stream) {
        return this.target.installProbe(stream);
    }

    public void uninstallProbe() {
        this.target.uninstallProbe();
    }

    public static boolean isJava9Compatible() {
        return isJava9Compatible;
    }

    private static void setJava9Compatible(boolean java9Compatible) {
        isJava9Compatible = java9Compatible;
    }

    static {
        KarafTestContainer.setJava9Compatible(JavaVersionUtil.getMajorVersion() >= 9);
    }
}

