/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.karaf.container.internal.runner;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.ops4j.pax.exam.karaf.container.internal.runner.CommandLineBuilder;
import org.ops4j.pax.exam.karaf.container.internal.runner.InternalRunner;
import org.ops4j.pax.exam.karaf.container.internal.runner.Runner;

public class KarafEmbeddedRunner
implements Runner {
    private InternalRunner runner = new InternalRunner();

    @Override
    public synchronized void exec(String[] environment, final File karafBase, String javaHome, String[] javaOpts, String[] javaEndorsedDirs, String[] javaExtDirs, final String karafHome, final String karafData, final String karafEtc, final String karafLog, final String[] karafOpts, final String[] opts, final String[] classPath, final String main, final String options, boolean security) {
        Thread thread = new Thread("KarafEmbeddedRunner"){

            @Override
            public void run() {
                String cp = this.buildCmdSeparatedString(classPath);
                System.setProperty("karaf.instances", karafHome + "/instances");
                System.setProperty("karaf.home", karafHome);
                System.setProperty("karaf.base", karafBase.getAbsolutePath());
                System.setProperty("karaf.data", karafData);
                System.setProperty("karaf.etc", karafEtc);
                System.setProperty("karaf.log", karafLog);
                System.setProperty("java.util.logging.config.file", karafEtc + "/java.util.logging.properties");
                CommandLineBuilder commandLine = new CommandLineBuilder();
                commandLine.append(karafOpts).append(opts).append("-cp").append(cp).append(options);
                try {
                    URL[] bundleUrls;
                    String[] arguments = commandLine.toArray();
                    File mainBundlePath = new File(karafBase, "lib");
                    List<File> mainBundles = this.searchMainBundle(mainBundlePath.listFiles());
                    if (null != mainBundles && !mainBundles.isEmpty()) {
                        bundleUrls = new URL[mainBundles.size()];
                        for (int i = 0; i < mainBundles.size(); ++i) {
                            bundleUrls[i] = mainBundles.get(i).toURL();
                        }
                    } else {
                        throw new RuntimeException("No Karaf main found");
                    }
                    URLClassLoader urlCl = new URLClassLoader(bundleUrls, this.getContextClassLoader());
                    Class<?> mainClass = urlCl.loadClass(main);
                    Constructor<?> constructor = mainClass.getConstructor(String[].class);
                    constructor.setAccessible(true);
                    Object karafInstance = constructor.newInstance(new Object[]{arguments});
                    Method method = mainClass.getMethod("launch", null);
                    method.invoke(karafInstance, (Object[])null);
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }

            private String buildCmdSeparatedString(String[] splitted) {
                StringBuilder together = new StringBuilder();
                for (String path : splitted) {
                    if (together.length() != 0) {
                        together.append(File.pathSeparator);
                    }
                    together.append(path);
                }
                return together.toString();
            }

            private List<File> searchMainBundle(File[] files) {
                ArrayList<File> mainBundles = new ArrayList<File>();
                for (File file : files) {
                    if (file.isDirectory() && file.getName().contains("boot")) {
                        mainBundles.addAll(this.searchMainBundle(file.listFiles()));
                        continue;
                    }
                    if (file.getPath().contains(File.separator + "boot")) {
                        mainBundles.add(file);
                        continue;
                    }
                    if (!file.getName().startsWith("karaf") || !file.getName().endsWith(".jar")) continue;
                    mainBundles.add(file);
                }
                return mainBundles;
            }
        };
        thread.start();
    }

    @Override
    public synchronized void shutdown() {
        this.runner.shutdown();
    }
}

