/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.karaf.container.internal.runner;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.ops4j.pax.exam.karaf.container.internal.runner.CommandLineBuilder;
import org.ops4j.pax.exam.karaf.container.internal.runner.InternalRunner;
import org.ops4j.pax.exam.karaf.container.internal.runner.Runner;

public abstract class BaseScriptRunner
implements Runner {
    protected InternalRunner runner;
    protected List<String> makeExec = new ArrayList<String>();
    protected String exec;

    public BaseScriptRunner(List<String> makeExec, String exec) {
        this.makeExec = makeExec;
        this.exec = exec;
        this.runner = new InternalRunner();
    }

    @Override
    public void exec(String[] environment, File karafBase, String javaHome, String[] javaOpts, String[] javaEndorsedDirs, String[] javaExtDirs, String karafHome, String karafData, String karafEtc, String[] karafOpts, String[] opts, String[] classPath, String main, String options, boolean security) {
        this.makeEnvironmentExecutable(karafBase);
        this.startSystem(environment, karafBase);
    }

    private void startSystem(final String[] environment, final File karafBase) {
        Thread thread = new Thread("KarafJavaRunner"){

            @Override
            public void run() {
                CommandLineBuilder commandLine = BaseScriptRunner.this.createCommandLine(environment, karafBase);
                BaseScriptRunner.this.runner.exec(commandLine, karafBase, environment);
            }
        };
        thread.start();
    }

    protected abstract CommandLineBuilder createCommandLine(String[] var1, File var2);

    private void makeEnvironmentExecutable(File karafBase) {
        new File(karafBase, this.exec).setExecutable(true);
        for (String execEntry : this.makeExec) {
            new File(karafBase, execEntry).setExecutable(true);
        }
    }

    @Override
    public void shutdown() {
        this.runner.shutdown();
    }
}

