/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.cm.internal;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationOptionConfigurationListener
implements ConfigurationListener,
ServiceTrackerCustomizer<ConfigurationAdmin, ConfigurationAdmin> {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationOptionConfigurationListener.class);
    private final Map<String, Object> properties;
    private final BundleContext context;
    private final String pid;
    private final boolean create;
    private final boolean override;
    private final boolean factory;
    private Configuration factoryConfiguration;

    public ConfigurationOptionConfigurationListener(String pid, Map<String, Object> properties, BundleContext context, boolean create, boolean override, boolean factory) {
        this.properties = properties;
        this.context = context;
        this.pid = pid;
        this.create = create;
        this.override = override;
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurationEvent(ConfigurationEvent event) {
        ServiceReference reference;
        ConfigurationAdmin service;
        if (!this.factory && this.override && event.getPid().equals(this.pid) && (service = (ConfigurationAdmin)this.context.getService(reference = event.getReference())) != null) {
            try {
                this.checkIfConfigurationNeeded(service);
            }
            finally {
                this.context.ungetService(reference);
            }
        }
    }

    private synchronized void checkIfConfigurationNeeded(ConfigurationAdmin service) {
        try {
            if (this.factory) {
                if (this.factoryConfiguration == null) {
                    this.factoryConfiguration = service.createFactoryConfiguration(this.pid, null);
                    this.factoryConfiguration.update(new Hashtable<String, Object>(this.properties));
                    LOG.info("Created new factory configuration for factory-pid {}, generated pid is {} with properties: {}", new Object[]{this.pid, this.factoryConfiguration.getPid(), this.properties});
                }
            } else {
                Configuration configuration = service.getConfiguration(this.pid, null);
                Dictionary dictionary = configuration.getProperties();
                if (dictionary != null) {
                    boolean update = false;
                    Set<Map.Entry<String, Object>> entrySet = this.properties.entrySet();
                    for (Map.Entry<String, Object> entry : entrySet) {
                        Object object = dictionary.get(entry.getKey());
                        if (object == null ? entry.getValue() == null : object.equals(entry.getValue())) continue;
                        update = true;
                        dictionary.put(entry.getKey(), entry.getValue());
                    }
                    if (update) {
                        LOG.info("Update existing configuration for pid {} with properties: {}", (Object)this.pid, ConfigurationOptionConfigurationListener.dictToString(dictionary));
                        configuration.update(dictionary);
                    }
                } else if (this.create) {
                    configuration.update(new Hashtable<String, Object>(this.properties));
                    LOG.info("Created new configuration for pid {} with properties: {}", (Object)this.pid, this.properties);
                }
            }
        }
        catch (IOException e) {
            LOG.warn("can't modify configuration for PID {}", (Object)this.pid, (Object)e);
        }
    }

    private static Object dictToString(Dictionary<String, Object> dictionary) {
        StringBuilder sb = new StringBuilder();
        Enumeration<String> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            if (sb.length() == 0) {
                sb.append("[");
            } else {
                sb.append(", ");
            }
            String key = keys.nextElement();
            sb.append(key);
            sb.append(": ");
            sb.append(dictionary.get(key));
        }
        return sb.append("]");
    }

    public ConfigurationAdmin addingService(ServiceReference<ConfigurationAdmin> reference) {
        ConfigurationAdmin service = (ConfigurationAdmin)this.context.getService(reference);
        if (service != null) {
            this.checkIfConfigurationNeeded(service);
        }
        return service;
    }

    public void modifiedService(ServiceReference<ConfigurationAdmin> reference, ConfigurationAdmin service) {
    }

    public void removedService(ServiceReference<ConfigurationAdmin> reference, ConfigurationAdmin service) {
        if (this.factoryConfiguration != null) {
            try {
                this.factoryConfiguration.delete();
            }
            catch (IOException e) {
                LOG.debug("Deleting factoryConfiguration failed", (Throwable)e);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.context.ungetService(reference);
    }
}

