/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.weld.impl.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.ops4j.pax.cdi.weld.impl.util.DelegatingBundleContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWiring;

class DelegatingBundle
implements Bundle {
    private static final String PACKAGE_CACHE = DelegatingBundle.class.getName() + ".packageCache";
    private static final String RESOURCE_CACHE_SIZE = DelegatingBundle.class.getName() + ".resourceCacheSize";
    private static final URL NOT_FOUND_RESOURCE;
    private Set<Bundle> bundles;
    private Bundle bundle;
    private BundleContext bundleContext;
    private final boolean hasDynamicImports;
    private final Map<String, URL> resourceCache;
    private final boolean packageCacheEnabled;
    private Map<String, Bundle> packageCache;

    DelegatingBundle(Collection<Bundle> bundles) {
        if (bundles.isEmpty()) {
            throw new IllegalArgumentException("At least one bundle is required");
        }
        this.bundles = Collections.newSetFromMap(new ConcurrentHashMap());
        this.bundles.addAll(bundles);
        Iterator<Bundle> iterator = bundles.iterator();
        this.bundle = iterator.next();
        this.bundleContext = new DelegatingBundleContext(this, this.bundle.getBundleContext());
        this.hasDynamicImports = this.hasDynamicImports(iterator);
        this.resourceCache = DelegatingBundle.initResourceCache();
        this.packageCacheEnabled = DelegatingBundle.initPackageCacheEnabled();
    }

    DelegatingBundle(Bundle bundle) {
        this(Collections.singletonList(bundle));
    }

    private static Map<String, URL> initResourceCache() {
        String value = System.getProperty(RESOURCE_CACHE_SIZE, "250");
        int size = Integer.parseInt(value);
        if (size > 0) {
            return Collections.synchronizedMap(new Cache(size));
        }
        return null;
    }

    private static boolean initPackageCacheEnabled() {
        String value = System.getProperty(PACKAGE_CACHE, "true");
        boolean enabled = Boolean.parseBoolean(value);
        return enabled;
    }

    private boolean hasDynamicImports(Iterator<Bundle> iterator) {
        while (iterator.hasNext()) {
            Bundle delegate = iterator.next();
            if (!DelegatingBundle.hasWildcardDynamicImport(delegate)) continue;
            return true;
        }
        return false;
    }

    private synchronized Map<String, Bundle> getPackageBundleMap() {
        if (this.packageCache == null) {
            this.packageCache = this.buildPackageBundleMap();
        }
        return this.packageCache;
    }

    private synchronized void reset() {
        this.resourceCache.clear();
        this.packageCache = null;
    }

    private Map<String, Bundle> buildPackageBundleMap() {
        HashMap<String, Bundle> map = new HashMap<String, Bundle>();
        Iterator<Bundle> iterator = this.bundles.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            List capabilities;
            Bundle b = iterator.next();
            BundleWiring wiring = (BundleWiring)b.adapt(BundleWiring.class);
            if (wiring == null || (capabilities = wiring.getCapabilities("osgi.wiring.package")) == null || capabilities.isEmpty()) continue;
            for (BundleCapability capability : capabilities) {
                String packageName;
                Map attributes = capability.getAttributes();
                if (attributes == null || map.containsKey(packageName = String.valueOf(attributes.get("osgi.wiring.package")))) continue;
                map.put(packageName, b);
            }
        }
        return map;
    }

    public Bundle getMainBundle() {
        return this.bundle;
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            Class clazz = this.bundle.loadClass(name);
            return clazz;
        }
        catch (ClassNotFoundException cnfe) {
            if (name.startsWith("java.")) {
                throw cnfe;
            }
            int index = name.lastIndexOf(46);
            if (index > 0 && this.bundles.size() > 1) {
                String packageName = name.substring(0, index);
                if (this.packageCacheEnabled) {
                    return this.findCachedClass(name, packageName, cnfe);
                }
                return this.findClass(name, packageName, cnfe);
            }
            throw cnfe;
        }
    }

    private Class<?> findCachedClass(String className, String packageName, ClassNotFoundException cnfe) throws ClassNotFoundException {
        Map<String, Bundle> map = this.getPackageBundleMap();
        Bundle b = map.get(packageName);
        if (b == null) {
            if (packageName.equals("sun.beans.infos") && className.endsWith("BeanInfo")) {
                throw cnfe;
            }
            return this.findClass(className, packageName, cnfe);
        }
        return b.loadClass(className);
    }

    private Class<?> findClass(String className, String packageName, ClassNotFoundException cnfe) throws ClassNotFoundException {
        Iterator<Bundle> iterator = this.bundles.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            Bundle delegate = iterator.next();
            if (this.hasDynamicImports && DelegatingBundle.hasWildcardDynamicImport(delegate)) continue;
            try {
                return delegate.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw cnfe;
    }

    private static boolean hasWildcardDynamicImport(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        if (headers != null) {
            String value = (String)headers.get("DynamicImport-Package");
            if (value == null) {
                return false;
            }
            return "*".equals(value.trim());
        }
        return false;
    }

    public void addBundle(Bundle b) {
        if (this.bundles.add(b)) {
            this.reset();
        }
    }

    public void removeBundle(Bundle b) {
        if (this.bundles.remove(b)) {
            this.reset();
        }
    }

    public URL getResource(String name) {
        URL resource = this.resourceCache == null ? this.findResource(name) : this.findCachedResource(name);
        return resource;
    }

    private URL findCachedResource(String name) {
        URL resource = this.bundle.getResource(name);
        if (resource == null) {
            resource = this.resourceCache.get(name);
            if (resource == null) {
                Iterator<Bundle> iterator = this.bundles.iterator();
                iterator.next();
                resource = this.findResource(name, iterator);
                this.resourceCache.put(name, resource == null ? NOT_FOUND_RESOURCE : resource);
            } else if (resource == NOT_FOUND_RESOURCE) {
                resource = null;
            }
        }
        return resource;
    }

    private URL findResource(String name) {
        Iterator<Bundle> iterator = this.bundles.iterator();
        return this.findResource(name, iterator);
    }

    private URL findResource(String name, Iterator<Bundle> iterator) {
        URL resource = null;
        while (iterator.hasNext() && resource == null) {
            Bundle delegate = iterator.next();
            resource = delegate.getResource(name);
        }
        return resource;
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> allResources = new ArrayList<URL>();
        for (Bundle b : this.bundles) {
            Enumeration e = b.getResources(name);
            DelegatingBundle.addToList(allResources, e);
        }
        return Collections.enumeration(allResources);
    }

    private static void addToList(List<URL> list, Enumeration<URL> enumeration) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                list.add(enumeration.nextElement());
            }
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public Enumeration findEntries(String arg0, String arg1, boolean arg2) {
        return this.bundle.findEntries(arg0, arg1, arg2);
    }

    public long getBundleId() {
        return this.bundle.getBundleId();
    }

    public URL getEntry(String arg0) {
        return this.bundle.getEntry(arg0);
    }

    public Enumeration getEntryPaths(String arg0) {
        return this.bundle.getEntryPaths(arg0);
    }

    public Dictionary getHeaders() {
        return this.bundle.getHeaders();
    }

    public Dictionary getHeaders(String arg0) {
        return this.bundle.getHeaders(arg0);
    }

    public long getLastModified() {
        return this.bundle.getLastModified();
    }

    public String getLocation() {
        return this.bundle.getLocation();
    }

    public ServiceReference[] getRegisteredServices() {
        return this.bundle.getRegisteredServices();
    }

    public ServiceReference[] getServicesInUse() {
        return this.bundle.getServicesInUse();
    }

    public Map getSignerCertificates(int arg0) {
        return this.bundle.getSignerCertificates(arg0);
    }

    public int getState() {
        return this.bundle.getState();
    }

    public String getSymbolicName() {
        return this.bundle.getSymbolicName();
    }

    public Version getVersion() {
        return this.bundle.getVersion();
    }

    public boolean hasPermission(Object arg0) {
        return this.bundle.hasPermission(arg0);
    }

    public void start() throws BundleException {
        this.bundle.start();
    }

    public void start(int arg0) throws BundleException {
        this.bundle.start(arg0);
    }

    public void stop() throws BundleException {
        this.bundle.stop();
    }

    public void stop(int arg0) throws BundleException {
        this.bundle.stop(arg0);
    }

    public void uninstall() throws BundleException {
        this.bundle.uninstall();
    }

    public void update() throws BundleException {
        this.bundle.update();
    }

    public void update(InputStream arg0) throws BundleException {
        this.bundle.update(arg0);
    }

    public int compareTo(Bundle other) {
        return this.bundle.compareTo((Object)other);
    }

    public <A> A adapt(Class<A> type) {
        return (A)this.bundle.adapt(type);
    }

    public File getDataFile(String filename) {
        return this.bundle.getDataFile(filename);
    }

    public String toString() {
        return "[DelegatingBundle: " + this.bundles + "]";
    }

    static {
        try {
            NOT_FOUND_RESOURCE = new URL("file://foo");
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
    }

    private static class Cache<K, V>
    extends LinkedHashMap<K, V> {
        private final int maxSize;

        Cache(int maxSize) {
            this(16, maxSize, 0.75f);
        }

        Cache(int initialSize, int maxSize, float loadFactor) {
            super(initialSize, loadFactor, true);
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxSize;
        }
    }
}

