/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.weld.impl.bda;

import java.util.Collections;
import java.util.List;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.CDI11Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.ops4j.pax.cdi.spi.scan.BeanDescriptorParser;
import org.ops4j.pax.cdi.spi.scan.BeanScanner;
import org.ops4j.pax.cdi.weld.impl.WeldParser;
import org.ops4j.pax.cdi.weld.impl.bda.BundleBeanDeploymentArchive;
import org.ops4j.pax.cdi.weld.impl.bda.ClassLoaderResourceLoader;
import org.osgi.framework.Bundle;

public class BundleDeployment
implements CDI11Deployment {
    private ServiceRegistry serviceRegistry = new SimpleServiceRegistry();
    private Iterable<Metadata<Extension>> extensions;
    private BundleBeanDeploymentArchive beanDeploymentArchive;

    public BundleDeployment(Bundle bundle, Bootstrap bootstrap, ClassLoader extensionClassLoader) {
        this.extensions = bootstrap.loadExtensions(extensionClassLoader);
        this.createBeanDeploymentArchive(bundle, extensionClassLoader);
    }

    private void createBeanDeploymentArchive(Bundle bundle, ClassLoader extensionClassLoader) {
        WeldParser parser = new WeldParser();
        BeanScanner scanner = new BeanScanner(bundle, (BeanDescriptorParser)parser);
        scanner.scan();
        this.beanDeploymentArchive = new BundleBeanDeploymentArchive("pax-cdi-bda" + bundle.getBundleId());
        this.beanDeploymentArchive.setBeansXml(parser.getModel());
        this.beanDeploymentArchive.setBeanClasses(scanner.getBeanClasses());
        ClassLoaderResourceLoader loader = new ClassLoaderResourceLoader(extensionClassLoader);
        this.beanDeploymentArchive.getServices().add(ResourceLoader.class, (Service)loader);
    }

    public List<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return Collections.singletonList(this.beanDeploymentArchive);
    }

    public BeanDeploymentArchive loadBeanDeploymentArchive(Class<?> beanClass) {
        return this.beanDeploymentArchive;
    }

    public BeanDeploymentArchive getBeanDeploymentArchive() {
        return this.beanDeploymentArchive;
    }

    public ServiceRegistry getServices() {
        return this.serviceRegistry;
    }

    public Iterable<Metadata<Extension>> getExtensions() {
        return this.extensions;
    }

    public BeanDeploymentArchive getBeanDeploymentArchive(Class<?> beanClass) {
        return this.beanDeploymentArchive;
    }
}

