/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.weld.impl;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.configuration.spi.ExternalConfiguration;
import org.jboss.weld.configuration.spi.helpers.ExternalConfigurationBuilder;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.ops4j.pax.cdi.spi.AbstractCdiContainer;
import org.ops4j.pax.cdi.spi.CdiClassLoaderBuilderCustomizer;
import org.ops4j.pax.cdi.spi.DestroyedLiteral;
import org.ops4j.pax.cdi.spi.InitializedLiteral;
import org.ops4j.pax.cdi.spi.util.Exceptions;
import org.ops4j.pax.cdi.weld.impl.InstanceManager;
import org.ops4j.pax.cdi.weld.impl.OsgiEnvironment;
import org.ops4j.pax.cdi.weld.impl.bda.BundleDeployment;
import org.ops4j.pax.cdi.weld.impl.util.OsgiProxyService;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeldCdiContainer
extends AbstractCdiContainer {
    private Logger log = LoggerFactory.getLogger(WeldCdiContainer.class);
    private InstanceManager instanceManager;
    private WeldBootstrap bootstrap;
    private BeanManagerImpl manager;
    private Object environment;
    private AtomicInteger pauses = new AtomicInteger();

    public WeldCdiContainer(Bundle ownBundle, Bundle bundle, Collection<Bundle> extensionBundles) {
        super(bundle, extensionBundles, Collections.singletonList(ownBundle));
        this.log.debug("creating Weld CDI container for bundle {}", (Object)bundle);
    }

    protected void doStart(Object start) {
        this.environment = start;
        try {
            this.doWithClassLoader(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    WeldCdiContainer.this.createBeanManager();
                    return null;
                }
            });
        }
        catch (Exception exc) {
            throw Exceptions.unchecked((Throwable)exc);
        }
    }

    private void createBeanManager() {
        this.bootstrap = new WeldBootstrap();
        BundleDeployment deployment = new BundleDeployment(this.getBundle(), (Bootstrap)this.bootstrap, this.getContextClassLoader());
        BeanDeploymentArchive beanDeploymentArchive = deployment.getBeanDeploymentArchive();
        this.pause();
        String contextId = this.getBundle().getSymbolicName() + ":" + this.getBundle().getBundleId();
        ExternalConfigurationBuilder configurationBuilder = new ExternalConfigurationBuilder().add(ConfigurationKey.RELAXED_CONSTRUCTION.get(), (Object)true).add(ConfigurationKey.CONCURRENT_DEPLOYMENT.get(), (Object)false);
        deployment.getServices().add(ExternalConfiguration.class, (Service)configurationBuilder.build());
        this.bootstrap.startContainer(contextId, (Environment)OsgiEnvironment.getInstance(), (Deployment)deployment);
        deployment.getServices().add(ProxyServices.class, (Service)new OsgiProxyService((BeanManager)this.bootstrap.getManager(beanDeploymentArchive), this.getContextClassLoader()));
        this.bootstrap.startInitialization();
        this.bootstrap.deployBeans();
        this.bootstrap.validateBeans();
        this.manager = this.bootstrap.getManager(beanDeploymentArchive);
        this.resume();
    }

    public void pause() {
        this.pauses.incrementAndGet();
    }

    public void resume() {
        if (this.pauses.decrementAndGet() == 0) {
            try {
                this.doWithClassLoader(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        WeldCdiContainer.this.bootstrap.endInitialization();
                        WeldCdiContainer.this.manager.fireEvent(WeldCdiContainer.this.environment, new Annotation[]{InitializedLiteral.APPLICATION});
                        return null;
                    }
                });
            }
            catch (Exception exc) {
                throw Exceptions.unchecked((Throwable)exc);
            }
        }
    }

    public void doStop() {
        try {
            this.doWithClassLoader(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    WeldCdiContainer.this.manager.fireEvent(WeldCdiContainer.this.environment, new Annotation[]{DestroyedLiteral.APPLICATION});
                    WeldCdiContainer.this.bootstrap.shutdown();
                    return null;
                }
            });
        }
        catch (Exception exc) {
            throw Exceptions.unchecked((Throwable)exc);
        }
    }

    public Event<Object> getEvent() {
        return this.getInstanceManager().getEvent();
    }

    public BeanManager getBeanManager() {
        return this.manager;
    }

    public Instance<Object> getInstance() {
        return this.getInstanceManager().getInstance();
    }

    private InstanceManager getInstanceManager() {
        if (this.instanceManager == null) {
            BeanManager beanManager = this.getBeanManager();
            this.instanceManager = new InstanceManager();
            AnnotatedType annotatedType = beanManager.createAnnotatedType(InstanceManager.class);
            InjectionTarget target = beanManager.createInjectionTarget(annotatedType);
            CreationalContext cc = beanManager.createCreationalContext(null);
            target.inject((Object)this.instanceManager, cc);
        }
        return this.instanceManager;
    }

    public <T> T unwrap(Class<T> wrappedClass) {
        if (wrappedClass.isAssignableFrom(WeldBootstrap.class)) {
            return wrappedClass.cast(this.bootstrap);
        }
        if (wrappedClass.isAssignableFrom(BeanManagerImpl.class)) {
            return wrappedClass.cast(this.manager);
        }
        if (wrappedClass.isAssignableFrom(CdiClassLoaderBuilderCustomizer.class)) {
            return wrappedClass.cast((Object)this);
        }
        return null;
    }

    public void startContext(Class<? extends Annotation> scope) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void stopContext(Class<? extends Annotation> scope) {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

