/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.weld.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.weld.bootstrap.api.SingletonProvider;
import org.jboss.weld.bootstrap.api.helpers.RegistrySingletonProvider;
import org.ops4j.pax.cdi.spi.CdiContainer;
import org.ops4j.pax.cdi.spi.CdiContainerFactory;
import org.ops4j.pax.cdi.weld.impl.WeldCdiContainer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeldCdiContainerFactory
implements CdiContainerFactory {
    private Logger log = LoggerFactory.getLogger(WeldCdiContainerFactory.class);
    private Map<Long, CdiContainer> containers = new HashMap<Long, CdiContainer>();
    private BundleContext bundleContext;

    public void activate(BundleContext bc) {
        this.bundleContext = bc;
        SingletonProvider.initialize((SingletonProvider)new RegistrySingletonProvider());
    }

    public void deactivate() {
        SingletonProvider.reset();
    }

    public String getProviderName() {
        return "Weld";
    }

    public CdiContainer createContainer(Bundle bundle, Collection<Bundle> extensions) {
        WeldCdiContainer container = new WeldCdiContainer(this.bundleContext.getBundle(), bundle, extensions);
        this.containers.put(bundle.getBundleId(), (CdiContainer)container);
        this.log.debug("Weld Container created");
        return container;
    }

    public CdiContainer getContainer(Bundle bundle) {
        return this.containers.get(bundle.getBundleId());
    }

    public Collection<CdiContainer> getContainers() {
        return Collections.unmodifiableCollection(this.containers.values());
    }

    public void removeContainer(Bundle bundle) {
        this.containers.remove(bundle.getBundleId());
    }
}

