/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.web.impl;

import java.util.Collection;
import java.util.EventListener;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.ops4j.pax.cdi.spi.CdiClassLoaderBuilder;
import org.ops4j.pax.cdi.spi.CdiClassLoaderBuilderCustomizer;
import org.ops4j.pax.cdi.spi.CdiContainer;
import org.ops4j.pax.cdi.web.ServletContextListenerFactory;
import org.ops4j.pax.web.service.spi.util.ResourceDelegatingBundleClassLoader;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdiServletContainerInitializer
implements ServletContainerInitializer {
    private static Logger log = LoggerFactory.getLogger(CdiServletContainerInitializer.class);
    private CdiContainer cdiContainer;
    private ServletContextListenerFactory servletContextListener;

    public CdiServletContainerInitializer(CdiContainer cdiContainer, ServletContextListenerFactory servletContextListener) {
        this.cdiContainer = cdiContainer;
        this.servletContextListener = servletContextListener;
    }

    public void onStartup(Set<Class<?>> classes, ServletContext ctx) throws ServletException {
        Bundle bundle = this.cdiContainer.getBundle();
        log.info("storing CdiContainer in ServletContext for [{}]", (Object)bundle);
        String contextId = String.format("%s:%d", bundle.getSymbolicName(), bundle.getBundleId());
        ctx.setInitParameter("WELD_CONTEXT_ID_KEY", contextId);
        CdiClassLoaderBuilderCustomizer customizer = (CdiClassLoaderBuilderCustomizer)this.cdiContainer.unwrap(CdiClassLoaderBuilderCustomizer.class);
        if (customizer != null) {
            customizer.setCdiClassLoaderBuilder((CdiClassLoaderBuilder)new PaxWebClassLoaderBuilder());
        }
        ctx.setAttribute("org.ops4j.pax.cdi.container", (Object)this.cdiContainer);
        ctx.addListener((EventListener)this.servletContextListener.createServletContextListener());
    }

    private static class PaxWebClassLoaderBuilder
    implements CdiClassLoaderBuilder {
        private PaxWebClassLoaderBuilder() {
        }

        public ClassLoader buildContextClassLoader(Object environment, Bundle beanArchive, Collection<Bundle> extensionBundles, Collection<Bundle> additionalBundles) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl instanceof ResourceDelegatingBundleClassLoader) {
                additionalBundles.forEach(arg_0 -> ((ResourceDelegatingBundleClassLoader)((ResourceDelegatingBundleClassLoader)cl)).addBundle(arg_0));
                return cl;
            }
            return null;
        }
    }
}

