/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.undertow.weld.impl;

import java.util.Map;
import javax.el.ELContextListener;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import org.jboss.weld.el.WeldELContextListener;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.servlet.WeldInitialListener;
import org.jboss.weld.servlet.api.ServletListener;
import org.jboss.weld.servlet.api.helpers.ForwardingServletListener;
import org.ops4j.pax.cdi.spi.CdiContainer;
import org.ops4j.pax.cdi.undertow.weld.impl.CdiInstanceFactoryBuilder;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeldServletContextListener
extends ForwardingServletListener {
    private static Logger log = LoggerFactory.getLogger(WeldServletContextListener.class);
    private ServletListener weldListener = new WeldInitialListener();
    private CdiContainer cdiContainer;

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        this.cdiContainer = (CdiContainer)context.getAttribute("org.ops4j.pax.cdi.container");
        Bundle bundle = this.cdiContainer.getBundle();
        String contextId = String.format("%s:%d", bundle.getSymbolicName(), bundle.getBundleId());
        context.setInitParameter("WELD_CONTEXT_ID_KEY", contextId);
        this.cdiContainer.start((Object)context);
        WeldManager manager = (WeldManager)this.cdiContainer.unwrap(WeldManager.class);
        CdiInstanceFactoryBuilder builder = new CdiInstanceFactoryBuilder((BeanManager)manager);
        Map attributes = (Map)context.getAttribute("org.ops4j.pax.web.attributes");
        if (attributes != null) {
            attributes.put("org.ops4j.pax.cdi.ClassIntrospecter", builder);
            log.info("registered CdiInstanceFactoryBuilder for Undertow");
        }
        context.setAttribute("org.ops4j.pax.cdi.BeanManager", (Object)this.cdiContainer.getBeanManager());
        JspFactory jspFactory = JspFactory.getDefaultFactory();
        if (jspFactory != null) {
            JspApplicationContext jspApplicationContext = jspFactory.getJspApplicationContext(context);
            jspApplicationContext.addELResolver(manager.getELResolver());
            jspApplicationContext.addELContextListener((ELContextListener)new WeldELContextListener());
        }
        super.contextInitialized(sce);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.cdiContainer.stop();
        ServletContext context = sce.getServletContext();
        context.removeAttribute("org.ops4j.pax.cdi.ClassIntrospecter");
        context.removeAttribute("org.ops4j.pax.cdi.BeanManager");
        super.contextDestroyed(sce);
    }

    protected ServletListener delegate() {
        return this.weldListener;
    }
}

