/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.spi.scan;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.xbean.finder.archive.Archive;
import org.ops4j.pax.cdi.spi.scan.BundleFilter;
import org.ops4j.pax.cdi.spi.scan.DefaultBundleFilter;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleArchive
implements Archive {
    private static Logger log = LoggerFactory.getLogger(BundleArchive.class);
    private static final String CLASS_EXT = ".class";
    private Bundle bundle;
    private Map<String, Archive.Entry> entries;
    private BundleFilter filter;

    public BundleArchive(Bundle bundle) {
        this(bundle, new DefaultBundleFilter());
    }

    public BundleArchive(Bundle bundle, BundleFilter filter) {
        this.bundle = bundle;
        this.entries = new HashMap<String, Archive.Entry>();
        this.filter = filter;
    }

    public Iterator<Archive.Entry> iterator() {
        this.entries = new HashMap<String, Archive.Entry>();
        for (String name : ((BundleWiring)this.bundle.adapt(BundleWiring.class)).listResources("/", "*.class", 3)) {
            String klass = this.toClassName("", name);
            if (!this.filter.accept(this.bundle, klass)) continue;
            URL url = this.bundle.getResource(name);
            BundleArchiveEntry archiveEntry = new BundleArchiveEntry(this.bundle, url, klass);
            this.entries.put(klass, archiveEntry);
        }
        return this.entries.values().iterator();
    }

    public InputStream getBytecode(String className) throws IOException, ClassNotFoundException {
        Archive.Entry entry = this.entries.get(className);
        if (entry == null) {
            return null;
        }
        return entry.getBytecode();
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.bundle.loadClass(className);
    }

    public Bundle getProvider(String className) {
        BundleArchiveEntry entry = (BundleArchiveEntry)this.entries.get(className);
        if (entry == null) {
            return null;
        }
        return entry.getProvider();
    }

    private String toClassName(String classPath, String file) {
        String klass = null;
        String[] parts = file.split("!");
        klass = parts.length > 1 ? parts[1] : file;
        if (klass.charAt(0) == '/') {
            klass = klass.substring(1);
        }
        String prefix = classPath;
        if (classPath.length() > 1) {
            if (classPath.charAt(0) == '/') {
                prefix = classPath.substring(1);
            }
            assert (klass.startsWith(prefix));
            int startIndex = prefix.length();
            if (!prefix.endsWith("/")) {
                ++startIndex;
            }
            klass = klass.substring(startIndex);
        }
        klass = klass.replace("/", ".").replace(CLASS_EXT, "");
        log.trace("file = {}, class = {}", (Object)file, (Object)klass);
        return klass;
    }

    private static class BundleArchiveEntry
    implements Archive.Entry {
        private Bundle provider;
        private URL path;
        private String name;

        BundleArchiveEntry(Bundle provider, URL path, String name) {
            this.provider = provider;
            this.path = path;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public InputStream getBytecode() throws IOException {
            return this.path.openStream();
        }

        public Bundle getProvider() {
            return this.provider;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof BundleArchiveEntry)) {
                return false;
            }
            BundleArchiveEntry other = (BundleArchiveEntry)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

