/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.spi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class BeanBundles {
    private static Map<ClassLoader, Bundle> bundleMap = new HashMap<ClassLoader, Bundle>();
    private static Set<Bundle> bundleSet = new HashSet<Bundle>();

    private BeanBundles() {
    }

    public static boolean isBeanBundle(Bundle candidate) {
        BundleWiring wiring = (BundleWiring)candidate.adapt(BundleWiring.class);
        if (wiring == null) {
            return false;
        }
        List wires = wiring.getRequiredWires("osgi.extender");
        for (BundleWire wire : wires) {
            String extender;
            Object object = wire.getCapability().getAttributes().get("osgi.extender");
            if (!(object instanceof String) || !(extender = (String)object).equals("osgi.cdi")) continue;
            return true;
        }
        return false;
    }

    public static boolean isActiveBeanBundle(Bundle candidate) {
        return bundleSet.contains(candidate);
    }

    public static synchronized void addBundle(ClassLoader cl, Bundle bundle) {
        bundleMap.put(cl, bundle);
        bundleSet.add(bundle);
    }

    public static synchronized void removeBundle(ClassLoader cl, Bundle bundle) {
        bundleMap.remove(cl);
        bundleSet.remove(bundle);
    }

    public static synchronized Bundle getBundle(ClassLoader cl) {
        return bundleMap.get(cl);
    }

    public static synchronized Bundle getCurrentBundle() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return bundleMap.get(cl);
    }

    public static void findExtensions(Bundle bundle, Set<Bundle> extensions) {
        List wires = ((BundleWiring)bundle.adapt(BundleWiring.class)).getRequiredWires(null);
        if (wires != null) {
            for (BundleWire wire : wires) {
                String ns = wire.getCapability().getNamespace();
                if (!"osgi.cdi.extension".equals(ns) && !"org.ops4j.pax.cdi.extension".equals(ns)) continue;
                Bundle b = wire.getProviderWiring().getBundle();
                extensions.add(b);
                BeanBundles.findExtensions(b, extensions);
            }
        }
    }
}

