/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.openwebbeans.impl;

import java.net.URL;
import java.util.List;
import org.apache.webbeans.spi.BeanArchiveService;
import org.ops4j.pax.cdi.spi.scan.BeanDescriptor;
import org.ops4j.pax.cdi.spi.scan.BeanDescriptorParser;
import org.ops4j.pax.cdi.spi.scan.BeanDiscoveryMode;

public class OpenWebBeansParser
implements BeanDescriptorParser {
    private BeanArchiveService archiveService;
    private BeanArchiveService.BeanArchiveInformation archiveInfo;

    public OpenWebBeansParser(BeanArchiveService archiveService) {
        this.archiveService = archiveService;
    }

    public BeanDescriptor parse(URL beansXml) {
        this.archiveInfo = this.archiveService.getBeanArchiveInformation(beansXml);
        return new BeanDescriptorImpl(beansXml);
    }

    private class BeanDescriptorImpl
    implements BeanDescriptor {
        private URL url;

        BeanDescriptorImpl(URL url) {
            this.url = url;
        }

        public String getVersion() {
            return OpenWebBeansParser.this.archiveInfo.getVersion();
        }

        public BeanDiscoveryMode getBeanDiscoveryMode() {
            return BeanDiscoveryMode.valueOf((String)OpenWebBeansParser.this.archiveInfo.getBeanDiscoveryMode().toString());
        }

        public boolean isClassExcluded(String clazz) {
            return OpenWebBeansParser.this.archiveInfo.isClassExcluded(clazz);
        }

        public boolean isPackageExcluded(String packageName) {
            return OpenWebBeansParser.this.archiveInfo.isPackageExcluded(packageName);
        }

        public List<String> getInterceptors() {
            return OpenWebBeansParser.this.archiveInfo.getInterceptors();
        }

        public List<String> getDecorators() {
            return OpenWebBeansParser.this.archiveInfo.getDecorators();
        }

        public List<String> getAlternativeClasses() {
            return OpenWebBeansParser.this.archiveInfo.getAlternativeClasses();
        }

        public List<String> getAlternativeStereotypes() {
            return OpenWebBeansParser.this.archiveInfo.getAlternativeStereotypes();
        }

        public List<String> getExcludedClasses() {
            return OpenWebBeansParser.this.archiveInfo.getExcludedClasses();
        }

        public List<String> getExcludedPackages() {
            return OpenWebBeansParser.this.archiveInfo.getExcludedPackages();
        }

        public URL getUrl() {
            return this.url;
        }
    }
}

