/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.jsf;

import javax.el.ELContextListener;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.jboss.weld.el.WeldELContextListener;
import org.jboss.weld.environment.servlet.jsf.AbstractForwardingApplication;
import org.jboss.weld.environment.servlet.util.AbstractForwardingELResolver;
import org.jboss.weld.environment.servlet.util.TransparentELResolver;

public class WeldApplication
extends AbstractForwardingApplication {
    private final Application application;
    private LazyBeanManagerIntegrationELResolver elResolver;
    private ExpressionFactory expressionFactory;
    private BeanManager beanManager;

    public WeldApplication(Application application) {
        this.application = application;
        application.addELContextListener((ELContextListener)new WeldELContextListener());
        this.elResolver = new LazyBeanManagerIntegrationELResolver();
        application.addELResolver((ELResolver)this.elResolver);
    }

    private void init() {
        ExpressionFactory factory = this.application.getExpressionFactory();
        BeanManager beanManager = this.getBeanManager();
        if (factory != null && beanManager != null) {
            this.elResolver.beanManagerReady(beanManager);
            this.expressionFactory = beanManager.wrapExpressionFactory(factory);
        }
    }

    @Override
    protected Application delegate() {
        this.init();
        return this.application;
    }

    @Override
    public ExpressionFactory getExpressionFactory() {
        this.init();
        if (this.expressionFactory == null) {
            return this.application.getExpressionFactory();
        }
        return this.expressionFactory;
    }

    private BeanManager getBeanManager() {
        FacesContext facesContext;
        if (this.beanManager == null && (facesContext = FacesContext.getCurrentInstance()) != null) {
            return this.lookupBeanManager(facesContext);
        }
        return this.beanManager;
    }

    private BeanManager lookupBeanManager(FacesContext facesContext) {
        Object obj = facesContext.getExternalContext().getContext();
        boolean notFound = false;
        try {
            if (obj instanceof ServletContext) {
                ServletContext ctx = (ServletContext)obj;
                BeanManager tmp = (BeanManager)ctx.getAttribute("org.ops4j.pax.cdi.BeanManager");
                if (tmp == null) {
                    return null;
                }
                this.beanManager = tmp;
                return this.beanManager;
            }
            notFound = true;
        }
        catch (Exception t) {
            throw new IllegalStateException("Exception fetching BeanManager instance!", t);
        }
        if (notFound) {
            throw new IllegalStateException("Not in a servlet or portlet environment!");
        }
        return null;
    }

    private static class LazyBeanManagerIntegrationELResolver
    extends AbstractForwardingELResolver {
        private ELResolver delegateResolver = new TransparentELResolver();

        LazyBeanManagerIntegrationELResolver() {
        }

        public void beanManagerReady(BeanManager beanManager) {
            this.delegateResolver = beanManager.getELResolver();
        }

        @Override
        protected ELResolver delegate() {
            return this.delegateResolver;
        }
    }
}

