/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.jetty.weld.impl;

import javax.el.ELContextListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import org.jboss.weld.el.WeldELContextListener;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.servlet.WeldInitialListener;
import org.jboss.weld.servlet.api.ServletListener;
import org.jboss.weld.servlet.api.helpers.ForwardingServletListener;
import org.ops4j.pax.cdi.jetty.weld.impl.JettyDecorator;
import org.ops4j.pax.cdi.spi.CdiContainer;
import org.ops4j.pax.cdi.spi.Injector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeldListener
extends ForwardingServletListener {
    private static Logger log = LoggerFactory.getLogger(WeldListener.class);
    private ServletListener weldListener = new WeldInitialListener();
    private CdiContainer cdiContainer;

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        this.cdiContainer = (CdiContainer)context.getAttribute("org.ops4j.pax.cdi.container");
        this.cdiContainer.start((Object)context);
        WeldManager manager = (WeldManager)this.cdiContainer.unwrap(WeldManager.class);
        Injector injector = new Injector(this.cdiContainer);
        context.setAttribute("org.ops4j.pax.cdi.injector", (Object)injector);
        JettyDecorator.process(context);
        log.info("registered Jetty decorator for JSR-299 injection");
        context.setAttribute("org.ops4j.pax.cdi.BeanManager", (Object)this.cdiContainer.getBeanManager());
        JspFactory jspFactory = JspFactory.getDefaultFactory();
        if (jspFactory != null) {
            JspApplicationContext jspApplicationContext = jspFactory.getJspApplicationContext(context);
            jspApplicationContext.addELResolver(manager.getELResolver());
            jspApplicationContext.addELContextListener((ELContextListener)new WeldELContextListener());
        }
        super.contextInitialized(sce);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        log.info("servlet context destroyed");
        this.cdiContainer.stop();
        sce.getServletContext().removeAttribute("org.ops4j.pax.cdi.injector");
        super.contextDestroyed(sce);
    }

    protected ServletListener delegate() {
        return this.weldListener;
    }
}

