/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.jetty.weld.impl;

import javax.servlet.ServletContext;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.Decorator;
import org.ops4j.pax.cdi.spi.Injector;

public class JettyDecorator
implements Decorator {
    public static final String INJECTOR_KEY = "org.ops4j.pax.cdi.injector";
    private ServletContext servletContext;
    private Injector injector;

    private JettyDecorator(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public static void process(ServletContext context) {
        ContextHandler.Context cc;
        ContextHandler handler;
        if (context instanceof ContextHandler.Context && (handler = (cc = (ContextHandler.Context)context).getContextHandler()) instanceof ServletContextHandler) {
            ServletContextHandler sch = (ServletContextHandler)handler;
            sch.getObjectFactory().addDecorator((Decorator)new JettyDecorator(context));
        }
    }

    private Injector getInjector() {
        if (this.injector == null) {
            this.injector = (Injector)this.servletContext.getAttribute(INJECTOR_KEY);
            if (this.injector == null) {
                throw new IllegalArgumentException("no injector found in servlet context attributes");
            }
        }
        return this.injector;
    }

    public <T> T decorate(T target) {
        this.getInjector().inject(target);
        return target;
    }

    public void destroy(Object target) {
        this.getInjector().destroy(target);
    }
}

