/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.jetty.openwebbeans.impl;

import javax.servlet.ServletContext;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.Decorator;
import org.ops4j.pax.cdi.spi.Injector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyDecorator
implements Decorator {
    public static final String INJECTOR_KEY = "org.ops4j.pax.cdi.injector";
    private static Logger log = LoggerFactory.getLogger(JettyDecorator.class);
    private ServletContext servletContext;
    private Injector injector;

    protected JettyDecorator(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public static void register(ServletContext context) {
        ContextHandler.Context cc;
        ContextHandler handler;
        if (context instanceof ContextHandler.Context && (handler = (cc = (ContextHandler.Context)context).getContextHandler()) instanceof ServletContextHandler) {
            ServletContextHandler sch = (ServletContextHandler)handler;
            sch.getObjectFactory().addDecorator((Decorator)new JettyDecorator(context));
            log.info("registered Jetty decorator for JSR-299 injection");
        }
    }

    protected Injector getInjector() {
        if (this.injector == null) {
            this.injector = (Injector)this.servletContext.getAttribute(INJECTOR_KEY);
            if (this.injector == null) {
                throw new IllegalArgumentException("no injector found in servlet context attributes");
            }
        }
        return this.injector;
    }

    public <T> T decorate(T target) {
        this.getInjector().inject(target);
        return target;
    }

    public void destroy(Object target) {
        this.getInjector().destroy(target);
    }
}

