/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ops4j.pax.cdi.api.Attribute;
import org.ops4j.pax.cdi.api.Filter;

public class Filters {
    private Filters() {
    }

    public static String getFilter(Collection<Annotation> annotations) {
        return Filters.and(Filters.getSubFilters(annotations));
    }

    public static String and(Collection<String> filters) {
        return Filters.combineFilter("&", filters);
    }

    public static String or(Collection<String> filters) {
        return Filters.combineFilter("|", filters);
    }

    public static String combineFilter(String op, Collection<String> filters) {
        String filter;
        switch (filters.size()) {
            case 0: {
                filter = null;
                break;
            }
            case 1: {
                filter = filters.iterator().next();
                break;
            }
            default: {
                StringBuilder sb = new StringBuilder();
                sb.append("(");
                sb.append(op);
                for (String f : filters) {
                    sb.append(f);
                }
                sb.append(")");
                filter = sb.toString();
            }
        }
        return filter;
    }

    public static List<String> getSubFilters(Iterable<Annotation> annotations) {
        ArrayList<String> filters = new ArrayList<String>();
        for (Annotation annotation : annotations) {
            Object value;
            if (annotation instanceof Filter) {
                String filter = ((Filter)annotation).value();
                if (!filter.startsWith("(") || !filter.endsWith(")")) {
                    filter = "(" + filter + ")";
                }
                filters.add(filter);
                continue;
            }
            Class<? extends Annotation> annClass = annotation.annotationType();
            Attribute attr = annClass.getAnnotation(Attribute.class);
            if (attr == null) continue;
            String name = attr.value();
            try {
                Method[] methods = annClass.getDeclaredMethods();
                if (methods == null || methods.length != 1) {
                    throw new IllegalArgumentException("Bad attribute " + annClass);
                }
                value = methods[0].invoke((Object)annotation, new Object[0]);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            filters.add("(" + name + "=" + value + ")");
        }
        Collections.sort(filters);
        return filters;
    }
}

