/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl.support;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public final class Configurable {
    private static final Boolean DEFAULT_BOOLEAN = false;
    private static final Byte DEFAULT_BYTE = 0;
    private static final Short DEFAULT_SHORT = 0;
    private static final Integer DEFAULT_INT = 0;
    private static final Long DEFAULT_LONG = 0L;
    private static final Float DEFAULT_FLOAT = Float.valueOf(0.0f);
    private static final Double DEFAULT_DOUBLE = 0.0;

    private Configurable() {
    }

    public static <T> T create(Class<T> type, Dictionary<?, ?> config) {
        HashMap map = new HashMap();
        Enumeration<?> e = config.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            map.put(key, config.get(key));
        }
        return Configurable.create(type, map);
    }

    public static <T> T create(Class<T> type, Map<?, ?> config) {
        ClassLoader cl = type.getClassLoader();
        Object result = Proxy.newProxyInstance(cl, new Class[]{type}, (InvocationHandler)new ConfigHandler(cl, config));
        return type.cast(result);
    }

    static class ConfigHandler
    implements InvocationHandler {
        private final ClassLoader m_cl;
        private final Map<?, ?> m_config;

        ConfigHandler(ClassLoader cl, Map<?, ?> config) {
            this.m_cl = cl;
            this.m_config = config;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object defaultValue;
            String name = this.getPropertyName(method.getName());
            Object result = this.convert(method.getGenericReturnType(), name, this.m_config.get(name), false);
            if (result == null && (defaultValue = this.getDefaultValue(method, name)) != null) {
                return defaultValue;
            }
            return result;
        }

        private Object convert(ParameterizedType type, String key, Object value) throws Exception {
            Class resultType = (Class<ArrayList>)((Object)type.getRawType());
            if (Class.class.isAssignableFrom(resultType)) {
                if (value == null) {
                    return null;
                }
                return this.m_cl.loadClass(value.toString());
            }
            if (Collection.class.isAssignableFrom(resultType)) {
                Collection<?> input = this.toCollection(key, value);
                if (resultType == Collection.class || resultType == List.class) {
                    resultType = ArrayList.class;
                } else if (resultType == Set.class || resultType == SortedSet.class) {
                    resultType = TreeSet.class;
                } else if (resultType == Queue.class) {
                    resultType = LinkedList.class;
                } else if (resultType.isInterface()) {
                    throw new RuntimeException("Unknown collection interface: " + resultType);
                }
                Collection result = (Collection)resultType.newInstance();
                if (input != null) {
                    Type componentType = type.getActualTypeArguments()[0];
                    for (Object i : input) {
                        result.add(this.convert(componentType, key, i, false));
                    }
                }
                return result;
            }
            if (Map.class.isAssignableFrom(resultType)) {
                Map<?, ?> input = this.toMap(key, value);
                if (resultType == SortedMap.class) {
                    resultType = TreeMap.class;
                } else if (resultType == Map.class) {
                    resultType = LinkedHashMap.class;
                } else if (resultType.isInterface()) {
                    throw new RuntimeException("Unknown map interface: " + resultType);
                }
                Map result = (Map)resultType.newInstance();
                Type keyType = type.getActualTypeArguments()[0];
                Type valueType = type.getActualTypeArguments()[1];
                for (Map.Entry<?, ?> entry : input.entrySet()) {
                    result.put(this.convert(keyType, key, entry.getKey(), false), this.convert(valueType, key, entry.getValue(), false));
                }
                return result;
            }
            throw new RuntimeException("Unhandled type: " + type);
        }

        private Object convert(Type type, String key, Object value, boolean useImplicitDefault) throws Exception {
            if (type instanceof ParameterizedType) {
                return this.convert((ParameterizedType)type, key, value);
            }
            if (type instanceof GenericArrayType) {
                return this.convertArray(((GenericArrayType)type).getGenericComponentType(), key, value);
            }
            Class resultType = (Class)type;
            if (resultType.isArray()) {
                return this.convertArray(resultType.getComponentType(), key, value);
            }
            if (resultType.isInstance(value)) {
                return value;
            }
            if (Boolean.class.equals((Object)resultType) || Boolean.TYPE.equals(resultType)) {
                if (value == null) {
                    return useImplicitDefault && resultType.isPrimitive() ? DEFAULT_BOOLEAN : null;
                }
                return Boolean.valueOf(value.toString());
            }
            if (Byte.class.equals((Object)resultType) || Byte.TYPE.equals(resultType)) {
                if (value == null) {
                    return useImplicitDefault && resultType.isPrimitive() ? DEFAULT_BYTE : null;
                }
                if (value instanceof Number) {
                    return ((Number)value).byteValue();
                }
                return Byte.valueOf(value.toString());
            }
            if (Short.class.equals((Object)resultType) || Short.TYPE.equals(resultType)) {
                if (value == null) {
                    return useImplicitDefault && resultType.isPrimitive() ? DEFAULT_SHORT : null;
                }
                if (value instanceof Number) {
                    return ((Number)value).shortValue();
                }
                return Short.valueOf(value.toString());
            }
            if (Integer.class.equals((Object)resultType) || Integer.TYPE.equals(resultType)) {
                if (value == null) {
                    return useImplicitDefault && resultType.isPrimitive() ? DEFAULT_INT : null;
                }
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                return Integer.valueOf(value.toString());
            }
            if (Long.class.equals((Object)resultType) || Long.TYPE.equals(resultType)) {
                if (value == null) {
                    return useImplicitDefault && resultType.isPrimitive() ? DEFAULT_LONG : null;
                }
                if (value instanceof Number) {
                    return ((Number)value).longValue();
                }
                return Long.valueOf(value.toString());
            }
            if (Float.class.equals((Object)resultType) || Float.TYPE.equals(resultType)) {
                if (value == null) {
                    return useImplicitDefault && resultType.isPrimitive() ? DEFAULT_FLOAT : null;
                }
                if (value instanceof Number) {
                    return Float.valueOf(((Number)value).floatValue());
                }
                return Float.valueOf(value.toString());
            }
            if (Double.class.equals((Object)resultType) || Double.TYPE.equals(resultType)) {
                if (value == null) {
                    return useImplicitDefault && resultType.isPrimitive() ? DEFAULT_DOUBLE : null;
                }
                if (value instanceof Number) {
                    return ((Number)value).doubleValue();
                }
                return Double.valueOf(value.toString());
            }
            if (Number.class.equals((Object)resultType)) {
                if (value == null) {
                    return null;
                }
                String numStr = value.toString();
                if (numStr.indexOf(46) > 0) {
                    return Double.valueOf(numStr);
                }
                return Long.valueOf(numStr);
            }
            if (String.class.isAssignableFrom(resultType)) {
                return value == null ? null : value.toString();
            }
            if (Enum.class.isAssignableFrom(resultType)) {
                if (value == null) {
                    return null;
                }
                Class enumType = resultType;
                return Enum.valueOf(enumType, value.toString().toUpperCase());
            }
            if (resultType.isInterface()) {
                Map<?, ?> map = this.toMap(key, value);
                return Configurable.create(resultType, map);
            }
            throw new RuntimeException("Unhandled type: " + type);
        }

        private Object convertArray(Type type, String key, Object value) throws Exception {
            Collection<?> input;
            if (value instanceof String) {
                String str = (String)value;
                if (type == Byte.class || type == Byte.TYPE) {
                    return str.getBytes("UTF-8");
                }
                if (type == Character.class || type == Character.TYPE) {
                    return str.toCharArray();
                }
            }
            if ((input = this.toCollection(key, value)) == null) {
                return null;
            }
            Class<?> componentClass = this.getRawClass(type);
            Object array = Array.newInstance(componentClass, input.size());
            int i = 0;
            for (Object next : input) {
                Array.set(array, i++, this.convert(type, key, next, false));
            }
            return array;
        }

        private Object getDefaultValue(Method method, String key) throws Exception {
            return this.convert(method.getGenericReturnType(), key, method.getDefaultValue(), true);
        }

        private Class<?> getRawClass(Type type) {
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (type instanceof Class) {
                return (Class)type;
            }
            throw new RuntimeException("Unhandled type: " + type);
        }

        private Collection<?> toCollection(String prefix, Object value) {
            if (value instanceof Collection) {
                return (Collection)value;
            }
            if (value == null) {
                ArrayList result = new ArrayList();
                String needle = prefix.concat(".");
                for (Map.Entry<?, ?> entry : this.m_config.entrySet()) {
                    String key = entry.getKey().toString();
                    if (!key.startsWith(needle)) continue;
                    int idx = 0;
                    try {
                        idx = Integer.parseInt(key.substring(needle.length()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    result.add(Math.min(result.size(), idx), entry.getValue());
                }
                return result;
            }
            if (value.getClass().isArray()) {
                if (value.getClass().getComponentType().isPrimitive()) {
                    int length = Array.getLength(value);
                    ArrayList<Object> result = new ArrayList<Object>(length);
                    for (int i = 0; i < length; ++i) {
                        result.add(Array.get(value, i));
                    }
                    return result;
                }
                return Arrays.asList((Object[])value);
            }
            if (value instanceof String) {
                String str = (String)value;
                if (str.startsWith("[") && str.endsWith("]")) {
                    str = str.substring(1, str.length() - 1);
                }
                return Arrays.asList(str.split("\\s*,\\s*"));
            }
            return Collections.singletonList(value);
        }

        private Map<?, ?> toMap(String prefix, Object value) {
            HashMap<String, Object> result;
            block5: {
                block4: {
                    if (value instanceof Map) {
                        return (Map)value;
                    }
                    result = new HashMap<String, Object>();
                    if (value != null) break block4;
                    String needle = prefix.concat(".");
                    for (Map.Entry<?, ?> entry : this.m_config.entrySet()) {
                        String key = entry.getKey().toString();
                        if (!key.startsWith(needle)) continue;
                        result.put(key.substring(needle.length()), entry.getValue());
                    }
                    break block5;
                }
                if (!(value instanceof String)) break block5;
                String str = (String)value;
                if (str.startsWith("{") && str.endsWith("}")) {
                    str = str.substring(1, str.length() - 1);
                }
                for (String entry : str.split("\\s*,\\s*")) {
                    String[] pair = entry.split("\\s*\\.\\s*", 2);
                    result.put(pair[0], pair[1]);
                }
            }
            return result;
        }

        private String getPropertyName(String id) {
            StringBuilder sb = new StringBuilder(id);
            if (id.startsWith("get")) {
                sb.delete(0, 3);
            } else if (id.startsWith("is")) {
                sb.delete(0, 2);
            }
            char c = sb.charAt(0);
            if (Character.isUpperCase(c)) {
                sb.setCharAt(0, Character.toLowerCase(c));
            }
            return sb.toString();
        }
    }
}

