/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl.context;

import java.lang.annotation.Annotation;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.enterprise.context.spi.AlterableContext;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.BeanManager;
import org.ops4j.pax.cdi.api.PrototypeScoped;

@Typed
public class PrototypeScopeContext
implements AlterableContext {
    private Map<Object, CreationalContext<?>> instanceMap = new IdentityHashMap();
    private BeanManager beanManager;
    private ThreadLocal<Object> service;

    public PrototypeScopeContext(BeanManager beanManager) {
        this.beanManager = beanManager;
        this.service = new ThreadLocal();
    }

    public Class<? extends Annotation> getScope() {
        return PrototypeScoped.class;
    }

    public <T> T get(Contextual<T> component, CreationalContext<T> creationalContext) {
        Object instance = component.create(creationalContext);
        this.instanceMap.put(instance, creationalContext);
        return (T)instance;
    }

    public <T> T get(Contextual<T> component) {
        return null;
    }

    public void destroy(Contextual<?> component) {
        Object instance = this.getService();
        CreationalContext<?> cc = this.instanceMap.remove(instance);
        if (cc != null) {
            component.destroy(instance, cc);
        }
    }

    public boolean isActive() {
        return true;
    }

    public CreationalContext<?> getCreationalContext() {
        return this.beanManager.createCreationalContext(null);
    }

    public <T> T getService() {
        return (T)this.service.get();
    }

    public <T> void setService(T service) {
        if (service == null) {
            this.service.remove();
        } else {
            this.service.set(service);
        }
    }
}

