/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl.component2;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.apache.felix.scr.impl.metadata.ServiceMetadata;
import org.ops4j.pax.cdi.api.Component;
import org.ops4j.pax.cdi.api.Config;
import org.ops4j.pax.cdi.api.Dynamic;
import org.ops4j.pax.cdi.api.Greedy;
import org.ops4j.pax.cdi.api.Optional;
import org.ops4j.pax.cdi.api.Service;
import org.ops4j.pax.cdi.extension.impl.component2.AbstractDescriptor;
import org.ops4j.pax.cdi.extension.impl.component2.BundleContextHolder;
import org.ops4j.pax.cdi.extension.impl.component2.ComponentRegistry;
import org.ops4j.pax.cdi.extension.impl.support.Filters;
import org.ops4j.pax.cdi.extension.impl.support.IterableInstance;
import org.ops4j.pax.cdi.extension.impl.support.SimpleBean;
import org.ops4j.pax.cdi.extension.impl.support.Types;
import org.ops4j.pax.cdi.spi.CdiContainer;
import org.ops4j.pax.cdi.spi.CdiContainerFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.ComponentContext;

public class GlobalDescriptor
extends AbstractDescriptor {
    private final ComponentRegistry registry;
    private final Map<InjectionPoint, Supplier<Object>> instanceSuppliers = new HashMap<InjectionPoint, Supplier<Object>>();
    private final List<Bean<?>> producers = new ArrayList();
    private CdiContainer container;
    private ComponentContext context;

    public GlobalDescriptor(ComponentRegistry registry) {
        super(registry);
        this.registry = registry;
        ServiceMetadata serviceMetadata = new ServiceMetadata();
        serviceMetadata.addProvide(Object.class.getName());
        serviceMetadata.setScope("singleton");
        this.setName(UUID.randomUUID().toString());
        this.setImmediate(true);
        this.setImplementationClassName(Object.class.getName());
        this.setConfigurationPolicy("ignore");
        this.getProperties().put(GlobalDescriptor.class.getName(), this);
        this.getProperties().put(ComponentRegistry.class.getName(), registry);
        this.setService(serviceMetadata);
    }

    public void pauseIfNeeded() {
        if (!this.getProducers().isEmpty()) {
            BundleContext bundleContext = BundleContextHolder.getBundleContext();
            ServiceReference factoryRef = bundleContext.getServiceReference(CdiContainerFactory.class);
            CdiContainerFactory factory = (CdiContainerFactory)bundleContext.getService(factoryRef);
            this.container = factory.getContainer(bundleContext.getBundle());
            this.container.pause();
        }
    }

    public <T> Bean<T> addGlobalInjectionPoint(Class<T> clazz, Set<Annotation> qualifiers) {
        return this.addGlobalInjectionPoint(new DummyInjectionPoint(clazz, qualifiers));
    }

    public Bean<?> addGlobalInjectionPoint(InjectionPoint injectionPoint) {
        Class clazz;
        boolean multiple;
        Service ref = (Service)injectionPoint.getAnnotated().getAnnotation(Service.class);
        Component cmp = (Component)injectionPoint.getAnnotated().getAnnotation(Component.class);
        Config cfg = (Config)injectionPoint.getAnnotated().getAnnotation(Config.class);
        Type type = injectionPoint.getType();
        if (type instanceof ParameterizedType) {
            Type raw = ((ParameterizedType)type).getRawType();
            if (raw == Instance.class) {
                multiple = true;
                clazz = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
            } else {
                multiple = false;
                clazz = (Class)((ParameterizedType)type).getRawType();
            }
        } else {
            if (type == Instance.class) {
                throw new IllegalArgumentException();
            }
            multiple = false;
            clazz = (Class)type;
        }
        if (multiple) {
            throw new IllegalArgumentException("@Global Instance<?> not supported: " + injectionPoint);
        }
        if (cfg != null) {
            throw new IllegalArgumentException("@Config @Global not supported: " + injectionPoint);
        }
        List<String> subFilters = Filters.getSubFilters(injectionPoint.getAnnotated().getAnnotations());
        if (ref == null) {
            subFilters.add("(org.ops4j.pax.cdi.private=true)");
        }
        String filter = Filters.and(subFilters);
        boolean optional = injectionPoint.getAnnotated().isAnnotationPresent(Optional.class);
        boolean greedy = injectionPoint.getAnnotated().isAnnotationPresent(Greedy.class);
        boolean dynamic = injectionPoint.getAnnotated().isAnnotationPresent(Dynamic.class);
        ReferenceMetadata reference = new ReferenceMetadata();
        reference.setName(injectionPoint.getAnnotated().toString());
        reference.setInterface(clazz.getName());
        reference.setTarget(filter);
        reference.setCardinality(optional ? "0..1" : "1..1");
        reference.setPolicy(dynamic ? "dynamic" : "static");
        reference.setPolicyOption(greedy ? "greedy" : "reluctant");
        this.addDependency(reference);
        Supplier<Object> supplier = () -> this.getService(injectionPoint, multiple, dynamic);
        SimpleBean<Object> bean = new SimpleBean<Object>(clazz, Dependent.class, injectionPoint, supplier);
        this.producers.add(bean);
        this.instanceSuppliers.put(injectionPoint, supplier);
        return bean;
    }

    @Override
    public ComponentContext getComponentContext() {
        return this.context;
    }

    protected Object getService(final InjectionPoint injectionPoint, boolean isInstance, boolean dynamic) {
        final ComponentContext cc = this.context;
        if (cc == null) {
            throw new IllegalStateException("Can not obtain @Component instance");
        }
        if (dynamic && isInstance) {
            Iterable iterable = () -> new Iterator<Object>(){
                final Object[] services;
                int idx;
                {
                    this.services = cc.locateServices(injectionPoint.toString());
                }

                @Override
                public boolean hasNext() {
                    return this.services != null && this.idx < this.services.length;
                }

                @Override
                public Object next() {
                    return this.services[this.idx++];
                }
            };
            return new IterableInstance(iterable);
        }
        if (isInstance) {
            final Object[] services = cc.locateServices(injectionPoint.toString());
            Iterable iterable = () -> new Iterator<Object>(){
                int idx;

                @Override
                public boolean hasNext() {
                    return services != null && this.idx < services.length;
                }

                @Override
                public Object next() {
                    return services[this.idx++];
                }
            };
            return new IterableInstance(iterable);
        }
        if (dynamic) {
            Class clazz = Types.getRawType(injectionPoint.getType());
            ClassLoader cl = ((BundleWiring)this.registry.getBundleContext().getBundle().adapt(BundleWiring.class)).getClassLoader();
            return Proxy.newProxyInstance(cl, new Class[]{clazz}, (p, method, args) -> {
                Object t = cc.locateService(injectionPoint.toString());
                return t != null ? method.invoke(t, args) : null;
            });
        }
        return cc.locateService(injectionPoint.toString());
    }

    @Override
    public List<Bean<?>> getProducers() {
        return this.producers;
    }

    @Override
    public Object activate(ComponentContext cc) {
        if (this.container != null) {
            this.container.resume();
            this.context = cc;
        }
        return new Object();
    }

    @Override
    public void deactivate(ComponentContext cc) {
        new Thread(() -> {
            if (this.container != null) {
                this.context = null;
                this.container.stop();
                this.container.start(new Object());
            }
        }).start();
    }

    static class DummyInjectionPoint
    implements InjectionPoint,
    Annotated {
        private final Class<?> type;
        private final Map<Class<? extends Annotation>, Annotation> annotations;

        DummyInjectionPoint(Class<?> type, Set<Annotation> annotations) {
            this.type = type;
            this.annotations = new HashMap<Class<? extends Annotation>, Annotation>();
            for (Annotation annotation : annotations) {
                this.annotations.put(annotation.annotationType(), annotation);
            }
        }

        public String toString() {
            return this.type.getName() + new ArrayList<Annotation>(this.annotations.values());
        }

        public Type getBaseType() {
            return this.type;
        }

        public Set<Type> getTypeClosure() {
            return Collections.singleton(this.type);
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            return (T)this.annotations.get(annotationType);
        }

        public Set<Annotation> getAnnotations() {
            return Collections.unmodifiableSet(new HashSet<Annotation>(this.annotations.values()));
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.annotations.containsKey(annotationType);
        }

        public Type getType() {
            return this.type;
        }

        public Set<Annotation> getQualifiers() {
            return this.getAnnotations();
        }

        public Bean<?> getBean() {
            return null;
        }

        public Member getMember() {
            return null;
        }

        public Annotated getAnnotated() {
            return this;
        }

        public boolean isDelegate() {
            return false;
        }

        public boolean isTransient() {
            return false;
        }
    }
}

