/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl.component2;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.felix.scr.impl.helper.ComponentMethod;
import org.apache.felix.scr.impl.helper.ComponentMethods;
import org.apache.felix.scr.impl.helper.ConfigAdminTracker;
import org.apache.felix.scr.impl.helper.InitReferenceMethod;
import org.apache.felix.scr.impl.helper.MethodResult;
import org.apache.felix.scr.impl.helper.ReferenceMethod;
import org.apache.felix.scr.impl.helper.ReferenceMethods;
import org.apache.felix.scr.impl.helper.SimpleLogger;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.ComponentActivator;
import org.apache.felix.scr.impl.manager.ComponentContainer;
import org.apache.felix.scr.impl.manager.ComponentContextImpl;
import org.apache.felix.scr.impl.manager.ComponentHolder;
import org.apache.felix.scr.impl.manager.ConfigurableComponentHolder;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.apache.felix.scr.impl.manager.ExtendedServiceEvent;
import org.apache.felix.scr.impl.manager.ExtendedServiceListener;
import org.apache.felix.scr.impl.manager.PrototypeServiceFactoryComponentManager;
import org.apache.felix.scr.impl.manager.RefPair;
import org.apache.felix.scr.impl.manager.RegionConfigurationSupport;
import org.apache.felix.scr.impl.manager.ScrConfiguration;
import org.apache.felix.scr.impl.manager.ServiceFactoryComponentManager;
import org.apache.felix.scr.impl.manager.SingleComponentManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.TargetedPID;
import org.ops4j.pax.cdi.extension.impl.component2.AbstractDescriptor;
import org.ops4j.pax.cdi.extension.impl.component2.ComponentDescriptor;
import org.ops4j.pax.cdi.extension.impl.component2.GlobalDescriptor;
import org.ops4j.pax.cdi.extension.impl.support.Consumer;
import org.ops4j.pax.cdi.extension.impl.support.PrivateRegistryWrapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentRegistry
implements ComponentActivator,
SimpleLogger {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentRegistry.class);
    ConfigAdminTracker configAdminTracker;
    private final ThreadLocal<List<ServiceReference<?>>> circularInfos = new ThreadLocal();
    private final BeanManager beanManager;
    private final BundleContext bundleContext;
    private final Map<Bean<?>, AbstractDescriptor> descriptors = new HashMap();
    private final List<ComponentHolder<?>> holders = new ArrayList();
    private final Map<String, ComponentHolder<?>> holdersByName = new HashMap();
    private final Map<String, Set<ComponentHolder<?>>> holdersByPid = new HashMap();
    private final ScrConfiguration m_configuration = new ScrConfigurationImpl();
    private final Map<String, ListenerInfo> listenerMap = new HashMap<String, ListenerInfo>();
    private final Map<ExtendedServiceListener, ServiceListener> privateListeners = new HashMap<ExtendedServiceListener, ServiceListener>();
    private final AtomicInteger componentId = new AtomicInteger();
    private final Map<ServiceReference<?>, List<Entry>> m_missingDependencies = new HashMap();
    private final ConcurrentMap<Long, RegionConfigurationSupport> bundleToRcsMap = new ConcurrentHashMap<Long, RegionConfigurationSupport>();
    private final Executor m_componentActor = Executors.newSingleThreadExecutor();
    private final AtomicBoolean started = new AtomicBoolean();

    public ComponentRegistry(BeanManager beanManager, BundleContext bundleContext) {
        this.beanManager = beanManager;
        this.bundleContext = new PrivateRegistryWrapper(bundleContext);
    }

    public BeanManager getBeanManager() {
        return this.beanManager;
    }

    public void preStart(AfterBeanDiscovery event, GlobalDescriptor global) {
        for (AbstractDescriptor descriptor : this.descriptors.values()) {
            for (Bean<?> bean : descriptor.getProducers()) {
                event.addBean(bean);
            }
        }
        global.validate(this);
        global.pauseIfNeeded();
        CdiComponentHolder h = new CdiComponentHolder(this, global);
        h.enableComponents(false);
        for (Bean<?> bean : global.getProducers()) {
            event.addBean(bean);
        }
    }

    @Override
    public <T> boolean enterCreate(ServiceReference<T> serviceReference) {
        List<ServiceReference<?>> info = this.circularInfos.get();
        if (info == null) {
            info = new ArrayList();
            this.circularInfos.set(info);
        }
        if (info.contains(serviceReference)) {
            this.log(1, "Circular reference detected trying to get service {0}: stack of references: {1}", new Object[]{serviceReference, info}, null);
            return true;
        }
        this.log(4, "getService  {0}: stack of references: {1}", new Object[]{serviceReference, info}, null);
        info.add(serviceReference);
        return false;
    }

    @Override
    public <T> void leaveCreate(ServiceReference<T> serviceReference) {
        List<ServiceReference<?>> info = this.circularInfos.get();
        if (info != null) {
            if (!info.isEmpty() && info.iterator().next().equals(serviceReference)) {
                this.circularInfos.remove();
            } else {
                info.remove(serviceReference);
            }
        }
    }

    public void start() {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        for (AbstractDescriptor abstractDescriptor : this.descriptors.values()) {
            abstractDescriptor.validate(this);
            ComponentHolder<?> h = new CdiComponentHolder(this, abstractDescriptor);
            this.holders.add(h);
        }
        for (ComponentHolder componentHolder : this.holders) {
            if (this.holdersByName.put(componentHolder.getComponentMetadata().getName(), componentHolder) == null) continue;
            throw new ComponentException("The component name '{0}" + componentHolder.getComponentMetadata().getName() + "' has already been registered.");
        }
        for (ComponentHolder componentHolder : this.holders) {
            for (String pid : componentHolder.getComponentMetadata().getConfigurationPid()) {
                Set set = this.holdersByPid.computeIfAbsent(pid, k -> new HashSet());
                set.add(componentHolder);
            }
        }
        ConfigAdminTracker tracker = null;
        for (ComponentHolder<?> holder : this.holders) {
            if (holder.getComponentMetadata().isConfigurationIgnored()) continue;
            tracker = new ConfigAdminTracker(this);
            break;
        }
        this.configAdminTracker = tracker;
        for (ComponentHolder<?> h : this.holders) {
            try {
                h.enableComponents(false);
            }
            catch (RuntimeException e) {
                h.disableComponents(false);
                throw e;
            }
        }
    }

    public void stop() {
        int reason = this.bundleContext.getBundle().getState() == 16 ? 6 : 5;
        for (ComponentHolder<?> h : this.holders) {
            h.disposeComponents(reason);
        }
    }

    public ComponentDescriptor addComponent(Bean<Object> component) {
        ComponentDescriptor descriptor = new ComponentDescriptor(component, this);
        this.descriptors.put(component, descriptor);
        return descriptor;
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public Set<Bean<?>> getComponents() {
        return this.descriptors.keySet();
    }

    public ComponentDescriptor getDescriptor(Bean<?> component) {
        return (ComponentDescriptor)this.descriptors.get(component);
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public ScrConfiguration getConfiguration() {
        return this.m_configuration;
    }

    @Override
    public void schedule(Runnable runnable) {
        if (this.isActive()) {
            this.m_componentActor.execute(runnable);
        }
    }

    @Override
    public long registerComponentId(AbstractComponentManager<?> sAbstractComponentManager) {
        return this.componentId.incrementAndGet();
    }

    @Override
    public void unregisterComponentId(AbstractComponentManager<?> sAbstractComponentManager) {
    }

    @Override
    public <S, T> void registerMissingDependency(DependencyManager<S, T> dependencyManager, ServiceReference<T> serviceReference, int trackingCount) {
        if (serviceReference.getProperty("component.name") == null || serviceReference.getProperty("component.id") == null) {
            return;
        }
        List dependencyManagers = this.m_missingDependencies.computeIfAbsent(serviceReference, k -> new ArrayList());
        dependencyManagers.add(new Entry(dependencyManager, trackingCount));
    }

    @Override
    public <T> void missingServicePresent(final ServiceReference<T> serviceReference) {
        final List<Entry> dependencyManagers = this.m_missingDependencies.remove(serviceReference);
        if (dependencyManagers != null) {
            this.m_componentActor.execute(new Runnable(){

                @Override
                public void run() {
                    for (Entry entry : dependencyManagers) {
                        DependencyManager dm = entry.getDm();
                        dm.invokeBindMethodLate(serviceReference, entry.getTrackingCount());
                    }
                }

                public String toString() {
                    return "Late binding task of reference " + serviceReference + " for dependencyManagers " + dependencyManagers;
                }
            });
        }
    }

    @Override
    public void enableComponent(String name) {
        Collection<ComponentHolder<?>> holders = this.getComponentHoldersByName(name);
        for (ComponentHolder<?> holder : holders) {
            try {
                this.log(4, "Enabling Component", holder.getComponentMetadata(), null, null);
                holder.enableComponents(true);
            }
            catch (Throwable t) {
                this.log(1, "Cannot enable component", holder.getComponentMetadata(), null, t);
            }
        }
    }

    @Override
    public void disableComponent(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RegionConfigurationSupport setRegionConfigurationSupport(ServiceReference<ConfigurationAdmin> reference) {
        RegionConfigurationSupport trialRcs = new RegionConfigurationSupport(this, reference){

            @Override
            protected Collection<ComponentHolder<?>> getComponentHolders(TargetedPID pid) {
                return ComponentRegistry.this.getComponentHoldersByPid(pid);
            }
        };
        RegionConfigurationSupport rcs = this.registerRegionConfigurationSupport(trialRcs);
        for (ComponentHolder<?> holder : this.holders) {
            rcs.configureComponentHolder(holder);
        }
        return rcs;
    }

    public RegionConfigurationSupport registerRegionConfigurationSupport(RegionConfigurationSupport trialRcs) {
        Long bundleId = trialRcs.getBundleId();
        RegionConfigurationSupport previous = null;
        while (true) {
            RegionConfigurationSupport existing;
            if ((existing = this.bundleToRcsMap.putIfAbsent(bundleId, trialRcs)) == null) {
                trialRcs.start();
                return trialRcs;
            }
            if (existing == previous) {
                return existing;
            }
            if (existing.reference()) {
                previous = existing;
                continue;
            }
            previous = null;
        }
    }

    @Override
    public void unsetRegionConfigurationSupport(RegionConfigurationSupport rcs) {
        if (rcs.dereference()) {
            this.bundleToRcsMap.remove(rcs.getBundleId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServiceListener(String classNameFilter, Filter eventFilter, ExtendedServiceListener<ExtendedServiceEvent> listener) {
        ListenerInfo listenerInfo;
        if (eventFilter != null && eventFilter.toString().contains("org.ops4j.pax.cdi.private")) {
            Map<ExtendedServiceListener, ServiceListener> map = this.privateListeners;
            synchronized (map) {
                ServiceListener l = event -> listener.serviceChanged(new ExtendedServiceEvent(event));
                this.privateListeners.put(listener, l);
                try {
                    this.bundleContext.addServiceListener(l, "(&" + classNameFilter + eventFilter.toString() + ")");
                }
                catch (InvalidSyntaxException e) {
                    throw new IllegalArgumentException("invalid class name filter", e);
                }
            }
            return;
        }
        Map<String, ListenerInfo> map = this.listenerMap;
        synchronized (map) {
            this.log(4, "classNameFilter: " + classNameFilter + " event filter: " + eventFilter, null, null, null);
            listenerInfo = this.listenerMap.get(classNameFilter);
            if (listenerInfo == null) {
                listenerInfo = new ListenerInfo();
                this.listenerMap.put(classNameFilter, listenerInfo);
                try {
                    this.bundleContext.addServiceListener((ServiceListener)listenerInfo, classNameFilter);
                }
                catch (InvalidSyntaxException e) {
                    throw new IllegalArgumentException("invalid class name filter", e);
                }
            }
        }
        listenerInfo.add(eventFilter, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServiceListener(String className, Filter filter, ExtendedServiceListener<ExtendedServiceEvent> listener) {
        Map<Object, ListenerInfo> map;
        if (filter != null && filter.toString().contains("org.ops4j.pax.cdi.private")) {
            map = this.privateListeners;
            synchronized (map) {
                ServiceListener l = this.privateListeners.remove(listener);
                this.bundleContext.removeServiceListener(l);
            }
        }
        map = this.listenerMap;
        synchronized (map) {
            ListenerInfo listenerInfo = this.listenerMap.get(className);
            if (listenerInfo != null && listenerInfo.remove(filter, listener)) {
                this.listenerMap.remove(className);
                this.bundleContext.removeServiceListener((ServiceListener)listenerInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ComponentHolder<?>> getComponentHoldersByPid(TargetedPID targetedPid) {
        String pid = targetedPid.getServicePid();
        HashSet componentHoldersUsingPid = new HashSet();
        Map<String, Set<ComponentHolder<?>>> map = this.holdersByPid;
        synchronized (map) {
            Set<ComponentHolder<?>> set = this.holdersByPid.get(pid);
            if (set != null) {
                for (ComponentHolder<?> holder : set) {
                    if (!targetedPid.matchesTarget(holder.getActivator().getBundleContext().getBundle())) continue;
                    componentHoldersUsingPid.add(holder);
                }
            }
        }
        return componentHoldersUsingPid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ComponentHolder<?>> getComponentHolders() {
        Map<String, ComponentHolder<?>> map = this.holdersByName;
        synchronized (map) {
            return new ArrayList(this.holdersByName.values());
        }
    }

    public ComponentHolder<?> getComponentHolder(String name) {
        return this.holdersByName.get(name);
    }

    public Collection<ComponentHolder<?>> getComponentHoldersByName(String name) {
        if (name == null) {
            return this.holders;
        }
        ComponentHolder<?> componentHolder = this.holdersByName.get(name);
        if (componentHolder != null) {
            return Collections.singletonList(componentHolder);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isLogEnabled(int level) {
        if (level >= 4) {
            return LOG.isDebugEnabled();
        }
        if (level >= 3) {
            return LOG.isInfoEnabled();
        }
        if (level >= 2) {
            return LOG.isWarnEnabled();
        }
        return LOG.isErrorEnabled();
    }

    @Override
    public void log(int level, String pattern, Object[] arguments, ComponentMetadata metadata, Long componentId, Throwable ex) {
        if (this.isLogEnabled(level)) {
            String message = MessageFormat.format(pattern, arguments);
            this.log(level, message, metadata, componentId, ex);
        }
    }

    @Override
    public void log(int level, String message, ComponentMetadata metadata, Long componentId, Throwable ex) {
        if (this.isLogEnabled(level)) {
            if (metadata != null) {
                message = componentId != null ? "[" + metadata.getName() + "(" + componentId + ")] " + message : "[" + metadata.getName() + "] " + message;
            }
            if (level >= 4) {
                LOG.debug(message, ex);
            } else if (level >= 3) {
                LOG.info(message, ex);
            } else if (level >= 2) {
                LOG.warn(message, ex);
            } else {
                LOG.error(message, ex);
            }
        }
    }

    @Override
    public void log(int level, String message, Throwable ex) {
        this.log(level, message, null, ex);
    }

    @Override
    public void log(int level, String message, Object[] arguments, Throwable ex) {
        this.log(level, message, arguments, null, 0L, ex);
    }

    private static <S> S doCreate(AbstractComponentManager<S> manager, ComponentContextImpl<S> componentContext, Consumer<ComponentContextImpl<S>> setter) {
        AbstractDescriptor descriptor = (AbstractDescriptor)manager.getComponentMetadata();
        Object s = descriptor.activate(componentContext);
        componentContext.setImplementationObject(s);
        setter.accept(componentContext);
        componentContext.setImplementationAccessible(true);
        return (S)s;
    }

    private static <S> void doDestroy(AbstractComponentManager<S> manager, ComponentContextImpl<S> componentContext) {
        AbstractDescriptor descriptor = (AbstractDescriptor)manager.getComponentMetadata();
        descriptor.deactivate(componentContext);
    }

    static class ScrConfigurationImpl
    implements ScrConfiguration {
        ScrConfigurationImpl() {
        }

        @Override
        public int getLogLevel() {
            return 0;
        }

        @Override
        public boolean isFactoryEnabled() {
            return false;
        }

        @Override
        public boolean keepInstances() {
            return false;
        }

        @Override
        public boolean infoAsService() {
            return false;
        }

        @Override
        public long lockTimeout() {
            return 5000L;
        }

        @Override
        public long stopTimeout() {
            return 60000L;
        }
    }

    private static class CdiSingletonComponentManager<S>
    extends SingleComponentManager<S> {
        CdiSingletonComponentManager(ComponentContainer<S> container, ComponentMethods componentMethods) {
            super(container, componentMethods);
        }

        @Override
        protected S createImplementationObject(Bundle usingBundle, SingleComponentManager.SetImplementationObject<S> setter, ComponentContextImpl<S> componentContext) {
            return (S)ComponentRegistry.doCreate(this, componentContext, setter::presetComponentContext);
        }

        @Override
        protected void disposeImplementationObject(ComponentContextImpl<S> componentContext, int reason) {
            ComponentRegistry.doDestroy(this, componentContext);
        }
    }

    private static class CdiBundleComponentManager<S>
    extends ServiceFactoryComponentManager<S> {
        CdiBundleComponentManager(ComponentContainer<S> container, ComponentMethods componentMethods) {
            super(container, componentMethods);
        }

        @Override
        protected S createImplementationObject(Bundle usingBundle, SingleComponentManager.SetImplementationObject<S> setter, ComponentContextImpl<S> componentContext) {
            return (S)ComponentRegistry.doCreate(this, componentContext, setter::presetComponentContext);
        }

        @Override
        protected void disposeImplementationObject(ComponentContextImpl<S> componentContext, int reason) {
            ComponentRegistry.doDestroy(this, componentContext);
        }
    }

    private static class CdiPrototypeComponentManager<S>
    extends PrototypeServiceFactoryComponentManager<S> {
        CdiPrototypeComponentManager(ComponentContainer<S> container, ComponentMethods componentMethods) {
            super(container, componentMethods);
        }

        @Override
        protected S createImplementationObject(Bundle usingBundle, SingleComponentManager.SetImplementationObject<S> setter, ComponentContextImpl<S> componentContext) {
            return (S)ComponentRegistry.doCreate(this, componentContext, setter::presetComponentContext);
        }

        @Override
        protected void disposeImplementationObject(ComponentContextImpl<S> componentContext, int reason) {
            ComponentRegistry.doDestroy(this, componentContext);
        }
    }

    private static class EmptyMethods
    implements ComponentMethods,
    ReferenceMethods,
    ReferenceMethod {
        private EmptyMethods() {
        }

        @Override
        public void initComponentMethods(ComponentMetadata componentMetadata, Class<?> implementationObjectClass) {
        }

        @Override
        public ComponentMethod getActivateMethod() {
            return null;
        }

        @Override
        public ComponentMethod getDeactivateMethod() {
            return null;
        }

        @Override
        public ComponentMethod getModifiedMethod() {
            return null;
        }

        @Override
        public ReferenceMethods getBindMethods(String refName) {
            return this;
        }

        @Override
        public ReferenceMethod getBind() {
            return this;
        }

        @Override
        public ReferenceMethod getUnbind() {
            return null;
        }

        @Override
        public ReferenceMethod getUpdated() {
            return null;
        }

        @Override
        public InitReferenceMethod getInit() {
            return null;
        }

        @Override
        public MethodResult invoke(Object componentInstance, ComponentContextImpl<?> componentContext, RefPair<?, ?> refPair, MethodResult methodCallFailureResult, SimpleLogger logger) {
            return null;
        }

        @Override
        public <S, T> boolean getServiceObject(ComponentContextImpl<S> key, RefPair<S, T> refPair, BundleContext context, SimpleLogger logger) {
            return true;
        }
    }

    private static class CdiComponentHolder<S>
    extends ConfigurableComponentHolder<S> {
        CdiComponentHolder(ComponentActivator activator, ComponentMetadata metadata) {
            super(activator, metadata);
        }

        @Override
        protected ComponentMethods createComponentMethods() {
            return new EmptyMethods();
        }

        @Override
        protected AbstractComponentManager<S> createComponentManager(boolean factoryConfiguration) {
            ComponentMetadata metadata = this.getComponentMetadata();
            ComponentMethods componentMethods = this.getComponentMethods();
            switch (metadata.getServiceScope()) {
                case singleton: {
                    return new CdiSingletonComponentManager(this, componentMethods);
                }
                case bundle: {
                    return new CdiBundleComponentManager(this, componentMethods);
                }
                case prototype: {
                    return this.createPrototypeComponentManager(componentMethods);
                }
            }
            throw new IllegalStateException();
        }

        protected AbstractComponentManager<S> createPrototypeComponentManager(ComponentMethods componentMethods) {
            return new CdiPrototypeComponentManager(this, componentMethods);
        }
    }

    private static class Entry {
        private final DependencyManager<?, ?> dm;
        private final int trackingCount;

        private Entry(DependencyManager<?, ?> dm, int trackingCount) {
            this.dm = dm;
            this.trackingCount = trackingCount;
        }

        public <S, T> DependencyManager<S, T> getDm() {
            return this.dm;
        }

        public int getTrackingCount() {
            return this.trackingCount;
        }
    }

    private static class ListenerInfo
    implements ServiceListener {
        private Map<Filter, List<ExtendedServiceListener<ExtendedServiceEvent>>> filterMap = new HashMap<Filter, List<ExtendedServiceListener<ExtendedServiceEvent>>>();

        private ListenerInfo() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceChanged(ServiceEvent event) {
            Map<Filter, List<ExtendedServiceListener<ExtendedServiceEvent>>> filterMap;
            ServiceReference ref = event.getServiceReference();
            ExtendedServiceEvent extEvent = null;
            ExtendedServiceEvent endMatchEvent = null;
            ListenerInfo listenerInfo = this;
            synchronized (listenerInfo) {
                filterMap = this.filterMap;
            }
            for (Map.Entry entry : filterMap.entrySet()) {
                Filter filter = (Filter)entry.getKey();
                if (filter == null || filter.match(ref)) {
                    if (extEvent == null) {
                        extEvent = new ExtendedServiceEvent(event);
                    }
                    for (ExtendedServiceListener forwardTo : (List)entry.getValue()) {
                        forwardTo.serviceChanged(extEvent);
                    }
                    continue;
                }
                if (event.getType() != 2) continue;
                if (endMatchEvent == null) {
                    endMatchEvent = new ExtendedServiceEvent(8, ref);
                }
                for (ExtendedServiceListener forwardTo : (List)entry.getValue()) {
                    forwardTo.serviceChanged(endMatchEvent);
                }
            }
            if (extEvent != null) {
                extEvent.activateManagers();
            }
            if (endMatchEvent != null) {
                endMatchEvent.activateManagers();
            }
        }

        public synchronized void add(Filter filter, ExtendedServiceListener<ExtendedServiceEvent> listener) {
            this.filterMap = new HashMap<Filter, List<ExtendedServiceListener<ExtendedServiceEvent>>>(this.filterMap);
            List<ExtendedServiceListener<ExtendedServiceEvent>> listeners = this.filterMap.get(filter);
            if (listeners == null) {
                listeners = Collections.singletonList(listener);
            } else {
                listeners = new ArrayList<ExtendedServiceListener<ExtendedServiceEvent>>(listeners);
                listeners.add(listener);
            }
            this.filterMap.put(filter, listeners);
        }

        public synchronized boolean remove(Filter filter, ExtendedServiceListener<ExtendedServiceEvent> listener) {
            List<ExtendedServiceListener<ExtendedServiceEvent>> listeners = this.filterMap.get(filter);
            if (listeners != null) {
                this.filterMap = new HashMap<Filter, List<ExtendedServiceListener<ExtendedServiceEvent>>>(this.filterMap);
                listeners = new ArrayList<ExtendedServiceListener<ExtendedServiceEvent>>(listeners);
                listeners.remove(listener);
                if (listeners.isEmpty()) {
                    this.filterMap.remove(filter);
                } else {
                    this.filterMap.put(filter, listeners);
                }
            }
            return this.filterMap.isEmpty();
        }
    }
}

