/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl;

import java.lang.annotation.Annotation;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import org.ops4j.pax.cdi.api.event.BundleCdiEvent;
import org.ops4j.pax.cdi.api.event.BundleStarted;
import org.ops4j.pax.cdi.api.event.BundleStopped;
import org.ops4j.pax.cdi.spi.BeanBundles;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class BundleEventBridge
implements BundleTrackerCustomizer<Void> {
    private static Logger log = LoggerFactory.getLogger(BundleEventBridge.class);
    @Inject
    private BundleContext bundleContext;
    @Inject
    private Event<BundleCdiEvent> event;
    private BundleTracker<Void> bundleTracker;

    @PostConstruct
    public void start() {
        int stateMask = 63;
        this.bundleTracker = new BundleTracker(this.bundleContext, stateMask, (BundleTrackerCustomizer)this);
        this.bundleTracker.open();
    }

    @PreDestroy
    public void stop() {
        this.bundleTracker.close();
    }

    public Void addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        if (!BeanBundles.isActiveBeanBundle((Bundle)bundle)) {
            return null;
        }
        log.debug("adding bundle {} {}", (Object)bundle);
        Event<BundleCdiEvent> childEvent = this.select(bundleEvent);
        childEvent.fire((Object)new BundleCdiEvent(bundle, bundleEvent));
        return null;
    }

    private Event<BundleCdiEvent> select(BundleEvent bundleEvent) {
        if (bundleEvent != null) {
            switch (bundleEvent.getType()) {
                case 2: {
                    return this.event.select(new Annotation[]{new AnnotationLiteral<BundleStarted>(){}});
                }
                case 4: {
                    return this.event.select(new Annotation[]{new AnnotationLiteral<BundleStopped>(){}});
                }
            }
            return this.event;
        }
        return this.event;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, Void object) {
        Event<BundleCdiEvent> childEvent = this.select(bundleEvent);
        childEvent.fire((Object)new BundleCdiEvent(bundle, bundleEvent));
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, Void object) {
        Event<BundleCdiEvent> childEvent = this.select(bundleEvent);
        childEvent.fire((Object)new BundleCdiEvent(bundle, bundleEvent));
    }

    public void applicationScopeInitialized(@Observes @Initialized(value=ApplicationScoped.class) Object init) {
    }
}

