/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Inject;
import org.ops4j.pax.cdi.api.event.ServiceCdiEvent;
import org.ops4j.pax.cdi.extension.impl.OsgiExtension2;
import org.ops4j.pax.cdi.extension.impl.support.Filters;
import org.ops4j.pax.cdi.extension.impl.util.ParameterizedTypeLiteral;
import org.ops4j.pax.cdi.extension.impl.util.ServiceAddedLiteral;
import org.ops4j.pax.cdi.extension.impl.util.ServiceRemovedLiteral;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;

@ApplicationScoped
public class ServiceEventBridge
implements ServiceListener {
    @Inject
    private BundleContext bundleContext;
    @Inject
    private Event<Object> event;
    @Inject
    private OsgiExtension2 extension;
    private String filter;
    private Map<Annotation, Filter> filters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent serviceEvent) {
        Annotation qualifier = this.toQualifier(serviceEvent);
        if (qualifier == null) {
            return;
        }
        ServiceReference serviceReference = serviceEvent.getServiceReference();
        ServiceObjects serviceObjects = this.bundleContext.getServiceObjects(serviceReference);
        Object service = serviceObjects.getService();
        try {
            Class<?> klass = service.getClass();
            Event event = this.event;
            for (Map.Entry<Annotation, Filter> entry : this.filters.entrySet()) {
                if (!entry.getValue().match(serviceReference)) continue;
                event = event.select(new Annotation[]{entry.getKey()});
            }
            event.select(klass, new Annotation[]{qualifier}).fire(service);
            ParameterizedTypeLiteral literal = new ParameterizedTypeLiteral(ServiceCdiEvent.class, klass);
            ServiceCdiEvent cdiEvent = new ServiceCdiEvent(serviceReference, service);
            event.select((TypeLiteral)literal, new Annotation[]{qualifier}).fire((Object)cdiEvent);
        }
        finally {
            serviceObjects.ungetService(service);
        }
    }

    @PostConstruct
    public void init() {
        this.filter = Filters.or(this.extension.getObservedFilters());
        if (this.filter != null) {
            try {
                this.filters = new HashMap<Annotation, Filter>();
                for (Annotation annotation : this.extension.getObservedQualifiers()) {
                    String flt = Filters.getFilter(Collections.singleton(annotation));
                    if (flt == null) continue;
                    this.filters.put(annotation, this.bundleContext.createFilter(flt));
                }
                this.bundleContext.addServiceListener((ServiceListener)this, this.filter);
            }
            catch (InvalidSyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.filter != null) {
            this.bundleContext.removeServiceListener((ServiceListener)this);
        }
    }

    private Annotation toQualifier(ServiceEvent serviceEvent) {
        switch (serviceEvent.getType()) {
            case 1: {
                return new ServiceAddedLiteral();
            }
            case 4: {
                return new ServiceRemovedLiteral();
            }
        }
        return null;
    }

    public void applicationScopeInitialized(@Observes @Initialized(value=ApplicationScoped.class) Object init) {
    }
}

