/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.opensearch.client.Validatable;
import org.opensearch.common.Nullable;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

public class TermVectorsRequest
implements ToXContentObject,
Validatable {
    private final String index;
    @Nullable
    private final String type;
    private String id = null;
    private XContentBuilder docBuilder = null;
    private String routing = null;
    private String preference = null;
    private boolean realtime = true;
    private String[] fields = null;
    private boolean requestPositions = true;
    private boolean requestPayloads = true;
    private boolean requestOffsets = true;
    private boolean requestFieldStatistics = true;
    private boolean requestTermStatistics = false;
    private Map<String, String> perFieldAnalyzer = null;
    private Map<String, Integer> filterSettings = null;

    public TermVectorsRequest(String index, String docId) {
        this.index = index;
        this.type = null;
        this.id = docId;
    }

    @Deprecated
    public TermVectorsRequest(String index, String type, String docId) {
        this.index = index;
        this.type = type;
        this.id = docId;
    }

    public TermVectorsRequest(String index, XContentBuilder docBuilder) {
        this.index = index;
        this.type = null;
        this.docBuilder = docBuilder;
    }

    @Deprecated
    public TermVectorsRequest(String index, String type, XContentBuilder docBuilder) {
        this.index = index;
        this.type = type;
        this.docBuilder = docBuilder;
    }

    static TermVectorsRequest createFromTemplate(TermVectorsRequest template, String id) {
        TermVectorsRequest request = new TermVectorsRequest(template.getIndex(), template.getType(), id);
        request.realtime = template.getRealtime();
        request.requestPositions = template.requestPositions;
        request.requestPayloads = template.requestPayloads;
        request.requestOffsets = template.requestOffsets;
        request.requestFieldStatistics = template.requestFieldStatistics;
        request.requestTermStatistics = template.requestTermStatistics;
        if (template.routing != null) {
            request.setRouting(template.getRouting());
        }
        if (template.preference != null) {
            request.setPreference(template.getPreference());
        }
        if (template.fields != null) {
            request.setFields(template.getFields());
        }
        if (template.perFieldAnalyzer != null) {
            request.setPerFieldAnalyzer(template.perFieldAnalyzer);
        }
        if (template.filterSettings != null) {
            request.setFilterSettings(template.filterSettings);
        }
        return request;
    }

    public String getIndex() {
        return this.index;
    }

    @Deprecated
    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public void setFields(String ... fields) {
        this.fields = fields;
    }

    public String[] getFields() {
        return this.fields;
    }

    public void setPositions(boolean requestPositions) {
        this.requestPositions = requestPositions;
    }

    public void setPayloads(boolean requestPayloads) {
        this.requestPayloads = requestPayloads;
    }

    public void setOffsets(boolean requestOffsets) {
        this.requestOffsets = requestOffsets;
    }

    public void setFieldStatistics(boolean requestFieldStatistics) {
        this.requestFieldStatistics = requestFieldStatistics;
    }

    public void setTermStatistics(boolean requestTermStatistics) {
        this.requestTermStatistics = requestTermStatistics;
    }

    public void setPerFieldAnalyzer(Map<String, String> perFieldAnalyzer) {
        this.perFieldAnalyzer = perFieldAnalyzer;
    }

    public void setFilterSettings(Map<String, Integer> filterSettings) {
        this.filterSettings = filterSettings;
    }

    public void setRouting(String routing) {
        this.routing = routing;
    }

    public String getRouting() {
        return this.routing;
    }

    public void setPreference(String preference) {
        this.preference = preference;
    }

    public String getPreference() {
        return this.preference;
    }

    public void setRealtime(boolean realtime) {
        this.realtime = realtime;
    }

    public boolean getRealtime() {
        return this.realtime;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("_index", this.index);
        if (this.type != null) {
            builder.field("_type", this.type);
        }
        if (this.id != null) {
            builder.field("_id", this.id);
        }
        if (this.fields != null) {
            builder.field("fields", (Object)this.fields);
        }
        if (!this.requestPositions) {
            builder.field("positions", false);
        }
        if (!this.requestPayloads) {
            builder.field("payloads", false);
        }
        if (!this.requestOffsets) {
            builder.field("offsets", false);
        }
        if (!this.requestFieldStatistics) {
            builder.field("field_statistics", false);
        }
        if (this.requestTermStatistics) {
            builder.field("term_statistics", true);
        }
        if (this.perFieldAnalyzer != null) {
            builder.field("per_field_analyzer", this.perFieldAnalyzer);
        }
        if (this.docBuilder != null) {
            BytesReference doc = BytesReference.bytes((XContentBuilder)this.docBuilder);
            try (StreamInput stream = doc.streamInput();){
                builder.rawField("doc", (InputStream)stream, this.docBuilder.contentType());
            }
        }
        if (this.filterSettings != null) {
            String[] filterSettingNames;
            builder.startObject("filter");
            for (String settingName : filterSettingNames = new String[]{"max_num_terms", "min_term_freq", "max_term_freq", "min_doc_freq", "max_doc_freq", "min_word_length", "max_word_length"}) {
                if (!this.filterSettings.containsKey(settingName)) continue;
                builder.field(settingName, this.filterSettings.get(settingName));
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }
}

