/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.client.methods.AsyncByteConsumer;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.opensearch.client.Message;
import org.opensearch.client.ReactiveDataConsumer;
import org.reactivestreams.Publisher;

class ReactiveResponseConsumer
extends AsyncByteConsumer<HttpResponse> {
    private final BasicFuture<Message<HttpResponse, Publisher<ByteBuffer>>> responseFuture;
    private final ReactiveDataConsumer reactiveDataConsumer = new ReactiveDataConsumer();

    ReactiveResponseConsumer(FutureCallback<Message<HttpResponse, Publisher<ByteBuffer>>> responseCallback) {
        this.responseFuture = new BasicFuture((FutureCallback)Args.notNull(responseCallback, (String)"responseCallback"));
    }

    protected void onByteReceived(ByteBuffer buf, IOControl ioctrl) throws IOException {
        this.reactiveDataConsumer.consume(buf);
        ioctrl.requestInput();
    }

    public void onResponseReceived(HttpResponse response) throws HttpException, IOException {
        this.responseFuture.completed(new Message<HttpResponse, ReactiveDataConsumer>(response, this.reactiveDataConsumer));
    }

    public HttpResponse buildResult(HttpContext context) throws Exception {
        this.reactiveDataConsumer.complete();
        return null;
    }

    protected void releaseResources() {
        if (this.getException() != null) {
            this.reactiveDataConsumer.failed(this.getException());
            this.responseFuture.failed(this.getException());
        }
    }
}

