/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.nodes.stats.GarbageCollector;
import org.opensearch.client.opensearch.nodes.stats.JvmClasses;
import org.opensearch.client.opensearch.nodes.stats.JvmMemoryStats;
import org.opensearch.client.opensearch.nodes.stats.JvmThreads;
import org.opensearch.client.opensearch.nodes.stats.NodeBufferPool;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Jvm
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, Jvm> {
    @Nonnull
    private final Map<String, NodeBufferPool> bufferPools;
    @Nullable
    private final JvmClasses classes;
    @Nullable
    private final GarbageCollector gc;
    @Nullable
    private final JvmMemoryStats mem;
    @Nullable
    private final JvmThreads threads;
    @Nullable
    private final Long timestamp;
    @Nullable
    private final Time uptime;
    @Nullable
    private final Long uptimeInMillis;
    public static final JsonpDeserializer<Jvm> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Jvm::setupJvmDeserializer);

    private Jvm(Builder builder) {
        this.bufferPools = ApiTypeHelper.unmodifiable(builder.bufferPools);
        this.classes = builder.classes;
        this.gc = builder.gc;
        this.mem = builder.mem;
        this.threads = builder.threads;
        this.timestamp = builder.timestamp;
        this.uptime = builder.uptime;
        this.uptimeInMillis = builder.uptimeInMillis;
    }

    public static Jvm of(Function<Builder, ObjectBuilder<Jvm>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, NodeBufferPool> bufferPools() {
        return this.bufferPools;
    }

    @Nullable
    public final JvmClasses classes() {
        return this.classes;
    }

    @Nullable
    public final GarbageCollector gc() {
        return this.gc;
    }

    @Nullable
    public final JvmMemoryStats mem() {
        return this.mem;
    }

    @Nullable
    public final JvmThreads threads() {
        return this.threads;
    }

    @Nullable
    public final Long timestamp() {
        return this.timestamp;
    }

    @Nullable
    public final Time uptime() {
        return this.uptime;
    }

    @Nullable
    public final Long uptimeInMillis() {
        return this.uptimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.bufferPools)) {
            generator.writeKey("buffer_pools");
            generator.writeStartObject();
            for (Map.Entry<String, NodeBufferPool> item0 : this.bufferPools.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.classes != null) {
            generator.writeKey("classes");
            this.classes.serialize(generator, mapper);
        }
        if (this.gc != null) {
            generator.writeKey("gc");
            this.gc.serialize(generator, mapper);
        }
        if (this.mem != null) {
            generator.writeKey("mem");
            this.mem.serialize(generator, mapper);
        }
        if (this.threads != null) {
            generator.writeKey("threads");
            this.threads.serialize(generator, mapper);
        }
        if (this.timestamp != null) {
            generator.writeKey("timestamp");
            generator.write(this.timestamp.longValue());
        }
        if (this.uptime != null) {
            generator.writeKey("uptime");
            this.uptime.serialize(generator, mapper);
        }
        if (this.uptimeInMillis != null) {
            generator.writeKey("uptime_in_millis");
            generator.write(this.uptimeInMillis.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupJvmDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::bufferPools, JsonpDeserializer.stringMapDeserializer(NodeBufferPool._DESERIALIZER), "buffer_pools");
        op.add(Builder::classes, JvmClasses._DESERIALIZER, "classes");
        op.add(Builder::gc, GarbageCollector._DESERIALIZER, "gc");
        op.add(Builder::mem, JvmMemoryStats._DESERIALIZER, "mem");
        op.add(Builder::threads, JvmThreads._DESERIALIZER, "threads");
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp");
        op.add(Builder::uptime, Time._DESERIALIZER, "uptime");
        op.add(Builder::uptimeInMillis, JsonpDeserializer.longDeserializer(), "uptime_in_millis");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.bufferPools);
        result = 31 * result + Objects.hashCode(this.classes);
        result = 31 * result + Objects.hashCode(this.gc);
        result = 31 * result + Objects.hashCode(this.mem);
        result = 31 * result + Objects.hashCode(this.threads);
        result = 31 * result + Objects.hashCode(this.timestamp);
        result = 31 * result + Objects.hashCode(this.uptime);
        result = 31 * result + Objects.hashCode(this.uptimeInMillis);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Jvm other = (Jvm)o;
        return Objects.equals(this.bufferPools, other.bufferPools) && Objects.equals(this.classes, other.classes) && Objects.equals(this.gc, other.gc) && Objects.equals(this.mem, other.mem) && Objects.equals(this.threads, other.threads) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.uptime, other.uptime) && Objects.equals(this.uptimeInMillis, other.uptimeInMillis);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, Jvm> {
        @Nullable
        private Map<String, NodeBufferPool> bufferPools;
        @Nullable
        private JvmClasses classes;
        @Nullable
        private GarbageCollector gc;
        @Nullable
        private JvmMemoryStats mem;
        @Nullable
        private JvmThreads threads;
        @Nullable
        private Long timestamp;
        @Nullable
        private Time uptime;
        @Nullable
        private Long uptimeInMillis;

        public Builder() {
        }

        private Builder(Jvm o) {
            this.bufferPools = Builder._mapCopy(o.bufferPools);
            this.classes = o.classes;
            this.gc = o.gc;
            this.mem = o.mem;
            this.threads = o.threads;
            this.timestamp = o.timestamp;
            this.uptime = o.uptime;
            this.uptimeInMillis = o.uptimeInMillis;
        }

        private Builder(Builder o) {
            this.bufferPools = Builder._mapCopy(o.bufferPools);
            this.classes = o.classes;
            this.gc = o.gc;
            this.mem = o.mem;
            this.threads = o.threads;
            this.timestamp = o.timestamp;
            this.uptime = o.uptime;
            this.uptimeInMillis = o.uptimeInMillis;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder bufferPools(Map<String, NodeBufferPool> map) {
            this.bufferPools = Builder._mapPutAll(this.bufferPools, map);
            return this;
        }

        @Nonnull
        public final Builder bufferPools(String key, NodeBufferPool value) {
            this.bufferPools = Builder._mapPut(this.bufferPools, key, value);
            return this;
        }

        @Nonnull
        public final Builder bufferPools(String key, Function<NodeBufferPool.Builder, ObjectBuilder<NodeBufferPool>> fn) {
            return this.bufferPools(key, fn.apply(new NodeBufferPool.Builder()).build());
        }

        @Nonnull
        public final Builder classes(@Nullable JvmClasses value) {
            this.classes = value;
            return this;
        }

        @Nonnull
        public final Builder classes(Function<JvmClasses.Builder, ObjectBuilder<JvmClasses>> fn) {
            return this.classes(fn.apply(new JvmClasses.Builder()).build());
        }

        @Nonnull
        public final Builder gc(@Nullable GarbageCollector value) {
            this.gc = value;
            return this;
        }

        @Nonnull
        public final Builder gc(Function<GarbageCollector.Builder, ObjectBuilder<GarbageCollector>> fn) {
            return this.gc(fn.apply(new GarbageCollector.Builder()).build());
        }

        @Nonnull
        public final Builder mem(@Nullable JvmMemoryStats value) {
            this.mem = value;
            return this;
        }

        @Nonnull
        public final Builder mem(Function<JvmMemoryStats.Builder, ObjectBuilder<JvmMemoryStats>> fn) {
            return this.mem(fn.apply(new JvmMemoryStats.Builder()).build());
        }

        @Nonnull
        public final Builder threads(@Nullable JvmThreads value) {
            this.threads = value;
            return this;
        }

        @Nonnull
        public final Builder threads(Function<JvmThreads.Builder, ObjectBuilder<JvmThreads>> fn) {
            return this.threads(fn.apply(new JvmThreads.Builder()).build());
        }

        @Nonnull
        public final Builder timestamp(@Nullable Long value) {
            this.timestamp = value;
            return this;
        }

        @Nonnull
        public final Builder uptime(@Nullable Time value) {
            this.uptime = value;
            return this;
        }

        @Nonnull
        public final Builder uptime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.uptime(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder uptimeInMillis(@Nullable Long value) {
            this.uptimeInMillis = value;
            return this;
        }

        @Override
        @Nonnull
        public Jvm build() {
            this._checkSingleUse();
            return new Jvm(this);
        }
    }
}

