/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.nodes.stats.ClusterStateQueue;
import org.opensearch.client.opensearch.nodes.stats.ClusterStateStats;
import org.opensearch.client.opensearch.nodes.stats.PublishedClusterStates;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Discovery
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, Discovery> {
    @Nullable
    private final ClusterStateQueue clusterStateQueue;
    @Nullable
    private final ClusterStateStats clusterStateStats;
    @Nullable
    private final PublishedClusterStates publishedClusterStates;
    public static final JsonpDeserializer<Discovery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Discovery::setupDiscoveryDeserializer);

    private Discovery(Builder builder) {
        this.clusterStateQueue = builder.clusterStateQueue;
        this.clusterStateStats = builder.clusterStateStats;
        this.publishedClusterStates = builder.publishedClusterStates;
    }

    public static Discovery of(Function<Builder, ObjectBuilder<Discovery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final ClusterStateQueue clusterStateQueue() {
        return this.clusterStateQueue;
    }

    @Nullable
    public final ClusterStateStats clusterStateStats() {
        return this.clusterStateStats;
    }

    @Nullable
    public final PublishedClusterStates publishedClusterStates() {
        return this.publishedClusterStates;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.clusterStateQueue != null) {
            generator.writeKey("cluster_state_queue");
            this.clusterStateQueue.serialize(generator, mapper);
        }
        if (this.clusterStateStats != null) {
            generator.writeKey("cluster_state_stats");
            this.clusterStateStats.serialize(generator, mapper);
        }
        if (this.publishedClusterStates != null) {
            generator.writeKey("published_cluster_states");
            this.publishedClusterStates.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupDiscoveryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::clusterStateQueue, ClusterStateQueue._DESERIALIZER, "cluster_state_queue");
        op.add(Builder::clusterStateStats, ClusterStateStats._DESERIALIZER, "cluster_state_stats");
        op.add(Builder::publishedClusterStates, PublishedClusterStates._DESERIALIZER, "published_cluster_states");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.clusterStateQueue);
        result = 31 * result + Objects.hashCode(this.clusterStateStats);
        result = 31 * result + Objects.hashCode(this.publishedClusterStates);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Discovery other = (Discovery)o;
        return Objects.equals(this.clusterStateQueue, other.clusterStateQueue) && Objects.equals(this.clusterStateStats, other.clusterStateStats) && Objects.equals(this.publishedClusterStates, other.publishedClusterStates);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, Discovery> {
        @Nullable
        private ClusterStateQueue clusterStateQueue;
        @Nullable
        private ClusterStateStats clusterStateStats;
        @Nullable
        private PublishedClusterStates publishedClusterStates;

        public Builder() {
        }

        private Builder(Discovery o) {
            this.clusterStateQueue = o.clusterStateQueue;
            this.clusterStateStats = o.clusterStateStats;
            this.publishedClusterStates = o.publishedClusterStates;
        }

        private Builder(Builder o) {
            this.clusterStateQueue = o.clusterStateQueue;
            this.clusterStateStats = o.clusterStateStats;
            this.publishedClusterStates = o.publishedClusterStates;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder clusterStateQueue(@Nullable ClusterStateQueue value) {
            this.clusterStateQueue = value;
            return this;
        }

        @Nonnull
        public final Builder clusterStateQueue(Function<ClusterStateQueue.Builder, ObjectBuilder<ClusterStateQueue>> fn) {
            return this.clusterStateQueue(fn.apply(new ClusterStateQueue.Builder()).build());
        }

        @Nonnull
        public final Builder clusterStateStats(@Nullable ClusterStateStats value) {
            this.clusterStateStats = value;
            return this;
        }

        @Nonnull
        public final Builder clusterStateStats(Function<ClusterStateStats.Builder, ObjectBuilder<ClusterStateStats>> fn) {
            return this.clusterStateStats(fn.apply(new ClusterStateStats.Builder()).build());
        }

        @Nonnull
        public final Builder publishedClusterStates(@Nullable PublishedClusterStates value) {
            this.publishedClusterStates = value;
            return this;
        }

        @Nonnull
        public final Builder publishedClusterStates(Function<PublishedClusterStates.Builder, ObjectBuilder<PublishedClusterStates>> fn) {
            return this.publishedClusterStates(fn.apply(new PublishedClusterStates.Builder()).build());
        }

        @Override
        @Nonnull
        public Discovery build() {
            this._checkSingleUse();
            return new Discovery(this);
        }
    }
}

